/*
 * @(#)DrawingPanel.java    3.0 2001/01/31
 *
 * Luca Cabibbo 
 * Dipartimento di Informatica e Automazione 
 * Universit degli Studi Roma Tre 
 * cabibbo@dia.uniroma3.it 
 */ 
 
package fiji.grafica; 

import java.awt.Graphics; 
import javax.swing.*; 
import java.util.*; 

/** 
 * Un oggetto <code>DrawingPanel</code>  un pannello
 * su cui  possibile scrivere e disegnare. 
 * 
 * @version 3.0 
 * @author Luca Cabibbo 
 */ 
class DrawingPanel extends JPanel { 
    
    /** 
     * Collezione degli elementi grafici disegnati nel pannello. 
     */ 
    private Collection drawingEntries; 
    
    /** 
     * Crea un <code>DrawingPanel</code>, 
     * di larghezza <code>width</code> 
     * e altezza <code>height</code> punti. 
     */ 
    public DrawingPanel(int width, int heigth) { 
        super(); 
        this.setSize(width, heigth); 
        drawingEntries = new LinkedList(); 
    } 
    
    /** 
     * Aggiunge una entry grafica alla collezione degli elementi 
     * grafici disegnati nel pannello. 
     */ 
    public void add(DrawingEntry e) { 
        drawingEntries.add(e); 
    } 
    
    /** 
     * Disegna il pannello. 
     */ 
    public void paintComponent(Graphics g) { 
        super.paintComponent(g); 
        DrawingEntry de; 
        Iterator i = drawingEntries.iterator();
        while (i.hasNext()) { 
            de = (DrawingEntry) i.next(); 
            de.draw(g); 
        } 
    } 
} 