package fiji.robot; 

import java.awt.BorderLayout; 
import java.awt.Container; 
import java.awt.Dimension; 
import java.awt.Graphics; 
import java.awt.Point; 

import java.awt.event.*; 

import javax.swing.*; 

/** 
 * Una LRFrame fornisce un ambiente grafico per la 
 * visualizzazione di un robot in un labirinto. 
 */ 
class LRFrame extends JFrame  { 
    
    /** il labirinto */ 
    private Labirinto l; 
    /** il robot */ 
    private Robot r; 

    /* componenti grafici */ 
    private LRPanel p; 
    private RControlPanel cp; 
    private Container contentPane; 
    
    /* dimensioni della frame */ 
    int frameWidth; 
    int frameHeight; 
    
    /** 
     * Crea una frame con un robot in un labirinto. 
     */ 
    public LRFrame(Labirinto l) { 
        /* crea la frame */ 
        super(); 
        
        /* gestione eventi */ 
        this.addWindowListener( new LRFrameAdapter() );         

        /* labirinto */ 
        this.l = l; 
        
        /* robot */ 
        r = l.getRobot(); 
            
        /* content pane */ 
        this.contentPane = this.getContentPane(); 

        /* layout manager */ 
        // this.getContentPane().setLayout(new BorderLayout()); 

        /* crea il panel come componente della frame */
        p = new LRPanel(l,r); 
        this.contentPane.add(p, BorderLayout.CENTER); 
        
        /* dimensiona la frame */ 
        Dimension ld = l.dimensioni(); 
        /* this.setSize(this.getPreferredSize()); */ 
        this.frameWidth = ld.width*LRPanel.EDGE + LRPanel.WOFFSET; 
        this.frameHeight = ld.height*LRPanel.EDGE + LRPanel.HOFFSET; 
        this.setSize(frameWidth, frameHeight); 

        /* assegna il titolo */ 
        assegnaTitolo();

        /* aggiunge l'eventuale pannello di controllo */ 
        this.cp = null; 
        if (r!=null && r.isInterattivo()) 
            addControl(); 

        /* rende visibile */ 
        this.setVisible(true); 
        
    } 
    
    /* assegna il titolo */ 
    public void assegnaTitolo() { 
        if (r==null) 
            setTitle("Labirinto (" + l.descrizione() + ")"); 
        else if (r.isInterattivo()) 
            setTitle("Robot interattivo in un labirinto (" + l.descrizione() + ")"); 
        else 
            setTitle("Robot in un labirinto (" + l.descrizione() + ")"); 
    } 

    /* aggiunge il pannello di controllo */ 
    public void addControl() { 
        // pre: r!=null && r.isInterattivo() 
        /* crea il pannello di controllo */ 
        cp = new RControlPanel(r, this); 
        this.contentPane.add(cp, BorderLayout.NORTH); 

        /* ridimensiona la frame */ 
        Dimension ld = l.dimensioni(); 
        int wid = ld.width; 
        if (wid<3)
            wid= 3; 
        this.frameWidth = wid*LRPanel.EDGE + LRPanel.WOFFSET; 
        this.frameHeight += RControlPanel.HEIGHT; 
        this.setSize(frameWidth, frameHeight); 

        validate();
        repaint(); 
    } 

    public void setRobot() { 
        r = l.getRobot(); 
        p.setRobot(r); 
        if (r.isInterattivo())  { 
            addControl(); 
        }
        assegnaTitolo(); 
    } 
    
    /* per disegnare la frame bisogna disegnare la canvas */ 
    public void paintComponent(Graphics g) { 
        /* disegna gli elementi della frame */ 
        paintComponents(g); 
    } 
    
} 