package fiji.robot; 

import java.awt.BorderLayout; 
import java.awt.GridLayout; 
import java.awt.Color; 

import java.awt.event.*; 

import javax.swing.*; 

/** pannello di controllo per robot nel labirinto */ 
class RControlPanel extends JPanel 
    implements ActionListener { 
    
    static final int HEIGHT = 80; 
        
    private Robot r; 
    private JFrame f; 
    
    /* 
     * il pannello di controllo  composto da: 
     *   bottone    gira a destra
     *   bottone    gira a sinistra
     *   bottone    avanza
     *   bottone    dentro 
     *   campo      dentro 
     *   bottone    di fronte al muro 
     *   campo      di fronte al muro 
     */ 
    
    private JTextField dentroF; 
    private JTextField fronteAlMuroF; 
     
    private final String AVANZA = "avanza"; 
    private final String SINISTRA = "sinistra"; 
    private final String DESTRA = "destra"; 
    private final String DENTRO = "dentro?"; 
    private final String FRONTEALMURO = "fronte al muro?"; 

    public RControlPanel(Robot r, JFrame f) { 
        super(); 
        
        this.r = r;
        this.f = f;

        JPanel top = new JPanel(); 
        JPanel bottom = new JPanel(); 
                
        top.setLayout( new GridLayout(1,3) ); 
        bottom.setLayout( new GridLayout(2,2) ); 
        
        JButton giraSinistraB = new JButton("Gira a sinistra"); 
        giraSinistraB.setActionCommand(SINISTRA); 
        giraSinistraB.addActionListener(this); 
        top.add(giraSinistraB); 

        JButton avanzaB = new JButton("Avanza"); 
        avanzaB.setActionCommand(AVANZA);
        avanzaB.addActionListener(this); 
        top.add(avanzaB); 

        JButton giraDestraB = new JButton("Gira a destra"); 
        giraDestraB.setActionCommand(DESTRA); 
        giraDestraB.addActionListener(this); 
        top.add(giraDestraB); 

        JButton dentroB = new JButton("Dentro?"); 
        dentroB.setActionCommand(DENTRO); 
        dentroB.addActionListener(this); 
        bottom.add(dentroB); 
        
        dentroF = new JTextField("", 8); 
        dentroF.setEditable(false); 
        bottom.add(dentroF); 

        JButton fronteAlMuroB = new JButton("Di fronte al muro?"); 
        fronteAlMuroB.setActionCommand(FRONTEALMURO); 
        fronteAlMuroB.addActionListener(this); 
        bottom.add(fronteAlMuroB); 
        
        fronteAlMuroF = new JTextField("", 8); 
        fronteAlMuroF.setEditable(false); 
        bottom.add(fronteAlMuroF); 
        
        this.setLayout(new BorderLayout());
        this.add(top, "North"); 
        this.add(bottom, "South"); 
        this.setBackground(Color.gray); 
    } 
    
    private void clear() { 
        dentroF.setText(""); 
        fronteAlMuroF.setText(""); 
    } 
    
    /* gestione degli eventi */ 
    public void actionPerformed(ActionEvent evt) 
            throws RobotException { 
        String ac = evt.getActionCommand(); 
        if (ac.equals(DESTRA)) { 
            clear(); 
            r.giraDestra(); 
        } else if (ac.equals(SINISTRA)) { 
            clear(); 
            r.giraSinistra(); 
        } else if (ac.equals(AVANZA)) { 
            clear(); 
            // try { 
                r.avanza(); 
            // } catch (RobotException e) { } 
        } else if (ac.equals(DENTRO)) { 
            dentroF.setText(String.valueOf(r.dentro())); 
        } else if (ac.equals(FRONTEALMURO)) { 
            fronteAlMuroF.setText(String.valueOf(r.fronteAlMuro())); 
        } 
        f.repaint(); 
    }

} 