/*
 * @(#)RobotException.java    3.0 2001/01/31
 *
 * Luca Cabibbo 
 * Dipartimento di Informatica e Automazione 
 * Universit degli Studi Roma Tre 
 * cabibbo@dia.uniroma3.it 
 * 
 * @version 3.0 
 * @author Luca Cabibbo 
 */ 

package fiji.robot; 

/** 
 * Una RobotException  un errore generato se 
 * viene richiesta una operazione non valida 
 * riguardante un robot o un labirinto. 
 * 
 * Un errore di tipo RobotException viene generato se: 
 * (1) viene richiesta la creazione di un robot 
 * in un Labirinto nullo (<code>null</code>) 
 * o non vuoto (ovvero, che contiene gi un robot); 
 * (2) viene richiesto a un robot di effettuare 
 * una mossa non consentita; 
 * oppure (3) viene richiesta la creazione di un labirinto 
 * con una descrizione non prevista. 
 */ 
public class RobotException extends RuntimeException { 
    public RobotException(String s) { 
        super("Operazione non consentita: " + s); 
        this.printStackTrace(); 
        System.exit(0);
    } 
} 