/*
 * @(#)Collection.java    0.1 2000/05/22
 *
 * Luca Cabibbo 
 * Dipartimento di Informatica e Automazione 
 * Universit degli Studi Roma Tre 
 * cabibbo@dia.uniroma3.it 
 */ 

package fiji.util; 
import java.util.Iterator; 

/** 
 * Una <code>Collection</code>  una collezione, 
 * ovvero un gruppo di oggetti. 
 * Gli oggetti che appartengono alla collezione 
 * sono chiamati elementi della collezione. 
 * 
 * @version 0.1 
 * @author Luca Cabibbo 
 */ 
public interface Collection { 
    /* operazioni di base */ 
    
    /** 
     * Calcola la cardinalit di questa collezione, 
     * ovvero il numero di elementi contenuti 
     * in questa collezione. 
     */ 
    public int size(); 

    /** Verifica se questa collezione  vuota. */ 
    public boolean isEmpty(); 

    /** 
     * Verifica se questa collezione contiene (almeno) un elemento 
     * uguale a <code>obj</code>. 
     * Pi precisamente, se <code>obj</code>  <code>null</code> 
     * verifica se questa collezione contiene un elemento 
     * <code>null</code>, altrimenti verifica se contiene 
     * un elemento uguale a <code>obj</code>. 
     */ 
    public boolean contains(Object obj); 

    /** 
     * Inserisce l'elemento <code>obj</code> 
     * in questa collezione (opzionale). 
     * Restituisce <code>true</code> se l'elemento <code>obj</code>
     *  stato effettivamente inserito nella collezione. 
     */ 
    public boolean add(Object obj); 
    
    /** 
     * Rimuove da questa collezione 
     * un elemento uguale a <code>obj</code>, se presente (opzionale). 
     * Restituisce <code>true</code> se un elemento 
     * uguale a <code>obj</code>
     *  stato effettivamente rimosso dalla collezione. 
     */ 
    public boolean remove(Object obj); 
    
    /** 
     * Restituisce un iteratore sugli elementi di 
     * questa collezione. 
     */ 
    public Iterator iterator(); 
    
    /* operazioni insiemistiche */ 
    
    /** 
     * Verifica se questa collezione contiene tutti 
     * gli elementi contenuti nella collezione <code>c</code>. 
     */ 
    public boolean containsAll(Collection c); 

    /** 
     * Inserisce in questa collezione tutti gli elementi 
     * contenuti nella collezione <code>c</code> (opzionale). 
     * Restituisce <code>true</code> questa collezione 
     *  stata modificata dall'inserimento. 
     */ 
    public boolean addAll(Collection c); 
    
    /** 
     * Rimuove da questa collezione tutti gli elementi 
     * contenuti nella collezione <code>c</code> (opzionale). 
     * Restituisce <code>true</code> questa collezione 
     *  stata modificata dall'operazione di rimozione. 
     */ 
    public boolean removeAll(Collection c); 
    
    /** 
     * Rimuove da questa collezione tutti gli elementi 
     * che non sono contenuti 
     * nella collezione <code>c</code> (opzionale). 
     * Restituisce <code>true</code> questa collezione 
     *  stata modificata dall'operazione di rimozione. 
     */ 
    public boolean retainAll(Collection c); 
    
    /** 
     * Rimuove da questa collezione tutti gli elementi 
     * (opzionale). 
     */ 
    public void clear(); 
    
    /* operazioni array */ 
    
    /** 
     * Restituisce un array che contiene tutti gli elementi 
     * di questa collezione. 
     */ 
    public Object[] toArray(); 
    
    /** 
     * Verifica se questa collezione  uguale 
     * all'oggetto <code>obj</code>. 
     */ 
    public boolean equals(Object obj); 
} 