/*
 * @(#)List.java    0.1 2000/05/22
 *
 * Luca Cabibbo 
 * Dipartimento di Informatica e Automazione 
 * Universit degli Studi Roma Tre 
 * cabibbo@dia.uniroma3.it 
 */ 

package fiji.util; 
import java.util.Iterator; 

/** 
 * Una <code>List</code>  una sequenza di elementi, 
 * a cui  consentito anche un accesso posizionale. 
 * Il primo elemento (ovvero, quello di indice 0) 
 *  chiamato testa della lista. 
 * L'ultimo elemento  chiamato coda della lista. 
 * 
 * @version 0.1 
 * @author Luca Cabibbo 
 */ 
public interface List extends Collection { 
    /* operazioni di base */ 
    
    /** Calcola la lunghezza di questa lista. */ 
    public int size(); 

    /** Verifica se questa lista  vuota. */ 
    public boolean isEmpty(); 

    /** 
     * Verifica se questa lista contiene (almeno) un elemento 
     * uguale a <code>obj</code>. 
     * Pi precisamente, se <code>obj</code>  <code>null</code> 
     * verifica se questa lista contiene un elemento 
     * <code>null</code>, altrimenti verifica se contiene 
     * un elemento uguale a <code>obj</code>. 
     */ 
    public boolean contains(Object obj); 

    /** 
     * Inserisce l'elemento <code>obj</code> 
     * come ultimo elemento di questa lista (opzionale). 
     * Restituisce <code>true</code> se l'elemento <code>obj</code>
     *  stato effettivamente inserito nella lista. 
     */ 
    public boolean add(Object obj); 
    
    /** 
     * Rimuove da questa lista il primo elemento 
     * uguale a <code>obj</code> 
     * (ovvero, il pi vicino alla testa della lista), 
     * se presente (opzionale). 
     * Restituisce <code>true</code> se un elemento 
     * uguale a <code>obj</code>
     *  stato effettivamente rimosso dalla lista. 
     */ 
    public boolean remove(Object obj); 
    
    /** 
     * Restituisce un iteratore sugli elementi di 
     * questa lista, dal primo elemento all'ultimo. 
     */ 
    public Iterator iterator(); 
    
    /* operazioni insiemistiche */ 
    
    /** 
     * Verifica se questa lista contiene tutti 
     * gli elementi contenuti nella collezione <code>c</code>. 
     */ 
    public boolean containsAll(Collection c); 

    /** 
     * Inserisce nella coda di questa lista tutti gli elementi 
     * contenuti nella collezione <code>c</code> (opzionale). 
     * L'inserimento avviene nell'ordine in cui gli elementi 
     * di <code>c</code> vengono visitati dal suo iteratore. 
     * Restituisce <code>true</code> questa lista 
     *  stata modificata dall'inserimento. 
     */ 
    public boolean addAll(Collection c); 
    
    /** 
     * Rimuove da questa lista tutti gli elementi 
     * contenuti nella collezione <code>c</code> (opzionale). 
     * Restituisce <code>true</code> questa lista 
     *  stata modificata dall'operazione di rimozione. 
     */ 
    public boolean removeAll(Collection c); 
    
    /** 
     * Rimuove da questa lista tutti gli elementi 
     * che non sono contenuti 
     * nella collezione <code>c</code> (opzionale). 
     * Restituisce <code>true</code> questa lista 
     *  stata modificata dall'operazione di rimozione. 
     */ 
    public boolean retainAll(Collection c); 
    
    /** 
     * Rimuove da questa lista tutti gli elementi 
     * (opzionale). 
     */ 
    public void clear(); 
    
    /* operazioni array */ 
    
    /** 
     * Restituisce un array che contiene tutti gli elementi 
     * di questa lista, ciascuno nella posizione in cui 
     * compare nella lista. 
     */ 
    public Object[] toArray(); 
    
    /** 
     * Verifica se questa lista  uguale 
     * all'oggetto <code>obj</code>. 
     * Pi precisamente, restituisce <code>true</code> 
     * se anche <code>obj</code>  una lista 
     * e le due liste sono uguali, 
     * ovvero hanno la stessa lunghezza e ogni elemento di 
     * questa lista  uguale a quello che occupa 
     * la stessa posizione in <code>obj</code>. 
     */ 
    public boolean equals(Object obj); 
    
    /* operazioni di accesso posizionale */ 
    
    /** 
     * Restituisce l'elemento di questa lista 
     * di posizione <code>index</code>. 
     */ 
    public Object get(int index); 
        // pre: index>=0 && index<this.size() 
    
    /** 
     * Sostituisce l'elemento di questa lista 
     * di posizione <code>index</code> con <code>obj</code>, 
     * e restituisce l'elemento che precedentemente 
     * occupava la posizione <code>index</code> (opzionale). 
     */ 
    public Object set(int index, Object obj); 
        // pre: index>=0 && index<this.size() 

    /** 
     * Inserisce in questa lista l'elemento <code>obj</code>
     * nella posizione <code>index</code> (opzionale). 
     * Tutti gli elementi che precedentemente occupavano 
     * una posizione maggiore o uguale a <code>index</code>
     * vengono spostati di una posizione verso destra. 
     */ 
    public void add(int index, Object obj); 
        // pre: index>=0 && index<=this.size() 

    /** 
     * Rimuove da questa lista l'elemento 
     * di posizione <code>index</code>, 
     * restituendo tale elemento (opzionale). 
     * Tutti gli elementi che precedentemente occupavano 
     * una posizione maggiore di <code>index</code>
     * vengono spostati di una posizione verso sinistra. 
     */ 
    public Object remove(int index); 
        // pre: index>=0 && index<this.size() 
    
    /** 
     * Inserisce in questa lista tutti gli elementi 
     * contenuti nella collezione <code>c</code>, 
     * a partire dalla posizione <code>index</code> (opzionale). 
     * L'inserimento avviene nell'ordine in cui gli elementi 
     * di <code>c</code> vengono visitati dal suo iteratore. 
     * Restituisce <code>true</code> questa lista 
     *  stata modificata dall'inserimento. 
     */ 
    public boolean addAll(int index, Collection c); 
        // pre: index>=0 && index<=this.size() 
    
    /* operazioni di ricerca */ 
    
    /** 
     * Calcola l'indice del primo elemento di questa lista 
     * uguale a <code>obj</code>, 
     * oppure <code>-1</code> se la lista non contiene 
     * nessun elemento uguale a <code>obj</code>. 
     */ 
    public int indexOf(Object obj); 

    /** 
     * Calcola l'indice dell'ultimo elemento di questa lista 
     * uguale a <code>obj</code>, 
     * oppure <code>-1</code> se la lista non contiene 
     * nessun elemento uguale a <code>obj</code>. 
     */ 
    public int lastIndexOf(Object obj);     
} 