/*
 * @(#)Set.java    0.1 2000/05/22
 *
 * Luca Cabibbo 
 * Dipartimento di Informatica e Automazione 
 * Universit degli Studi Roma Tre 
 * cabibbo@dia.uniroma3.it 
 */ 

package fiji.util; 
import java.util.Iterator; 

/** 
 * Un <code>Set</code>  un insieme finito di oggetti. 
 * Gli elementi di un <code>Set</code> sono 
 * tra loro tutti distinti. 
 * 
 * @version 0.1 
 * @author Luca Cabibbo 
 */ 
public interface Set { 
    /* operazioni di base */ 
    
    /** 
     * Calcola la cardinalit di questo insieme, 
     * ovvero il numero di elementi contenuti 
     * in questo insieme. 
     */ 
    public int size(); 

    /** Verifica se questo insieme  vuoto. */ 
    public boolean isEmpty(); 

    /** 
     * Verifica se questo insieme contiene (almeno) un elemento 
     * uguale a <code>obj</code>. 
     * Pi precisamente, se <code>obj</code>  <code>null</code> 
     * verifica se questo insieme contiene un elemento 
     * <code>null</code>, altrimenti verifica se contiene 
     * un elemento uguale a <code>obj</code>. 
     */ 
    public boolean contains(Object obj); 

    /** 
     * Inserisce l'elemento <code>obj</code> 
     * in questo insieme (opzionale). 
     * L'elemento <code>obj</code> viene inserito solo 
     * se questo insieme non contiene gi un elemento 
     * uguale a <code>obj</code>. 
     * Restituisce <code>true</code> se l'elemento <code>obj</code>
     *  stato effettivamente inserito nell'insieme. 
     */ 
    public boolean add(Object obj); 
    
    /** 
     * Rimuove da questo insieme 
     * un elemento uguale a <code>obj</code>, se presente (opzionale). 
     * Restituisce <code>true</code> se un elemento 
     * uguale a <code>obj</code>
     *  stato effettivamente rimosso dall'insieme. 
     */ 
    public boolean remove(Object obj); 
    
    /** 
     * Restituisce un iteratore sugli elementi di 
     * questo insieme. 
     */ 
    public Iterator iterator(); 
    
    /* operazioni insiemistiche */ 
    
    /** 
     * Verifica se questo insieme contiene tutti 
     * gli elementi contenuti nella collezione <code>c</code>. 
     * In particolare, se anche <code>c</code> 
     *  un <code>Set</code>, 
     * verifica se <code>c</code>  un sotto-insieme 
     * di questo insieme. 
     */ 
    public boolean containsAll(Collection c); 

    /** 
     * Inserisce in questo insieme tutti gli elementi 
     * contenuti nella collezione <code>c</code> (opzionale). 
     * Restituisce <code>true</code> questo insieme 
     *  stata modificata dall'inserimento. 
     * In particolare, se anche <code>c</code> 
     *  un <code>Set</code>, 
     * realizza l'operazione di unione insiemistica 
     * tra questo insieme e <code>c</code>. 
     */ 
    public boolean addAll(Collection c); 
    
    /** 
     * Rimuove da questo insieme tutti gli elementi 
     * contenuti nella collezione <code>c</code> (opzionale). 
     * Restituisce <code>true</code> questo insieme 
     *  stata modificata dall'operazione di rimozione. 
     * In particolare, se anche <code>c</code> 
     *  un <code>Set</code>, 
     * realizza l'operazione di differenza insiemistica 
     * tra questo insieme e <code>c</code>. 
     */ 
    public boolean removeAll(Collection c); 
    
    /** 
     * Rimuove da questo insieme tutti gli elementi 
     * che non sono contenuti 
     * nella collezione <code>c</code> (opzionale). 
     * Restituisce <code>true</code> questo insieme 
     *  stata modificata dall'operazione di rimozione. 
     * In particolare, se anche <code>c</code> 
     *  un <code>Set</code>, 
     * realizza l'operazione di intersezione insiemistica 
     * tra questo insieme e <code>c</code>. 
     */ 
    public boolean retainAll(Collection c); 
    
    /** 
     * Rimuove da questo insieme tutti gli elementi 
     * (opzionale). 
     */ 
    public void clear(); 
    
    /* operazioni array */ 
    
    /** 
     * Restituisce un array che contiene tutti gli elementi 
     * di questo insieme. 
     */ 
    public Object[] toArray(); 
    
    /** 
     * Verifica se questo insieme  uguale 
     * all'oggetto <code>obj</code>. 
     * Pi precisamente, restituisce <code>true</code> 
     * se anche <code>obj</code>  un <code>Set</code> 
     * e i due insiemi sono uguali, 
     * nel senso che hanno la stessa cardinalit e ogni elemento 
     * di <code>obj</code>  contenuto in questo insieme. 
     */ 
    public boolean equals(Object obj); 
} 