DROP TABLE PRODOTTI;
DROP TABLE LISTINO;
DROP TABLE ACQUISTI;

CREATE TABLE PRODOTTI (
	PRODID 		CHAR(6) NOT NULL PRIMARY KEY,
	DESCRIZIONE	VARCHAR(30) NOT NULL		);

CREATE TABLE LISTINO (
	PRODID 	CHAR(6) NOT NULL REFERENCES PRODOTTI,
	NUM 	INT NOT NULL CHECK (NUM > 0),
	DATA 	DATE NOT NULL,
	PREZZO 	DEC(8,2) NOT NULL CHECK (PREZZO > 0),
	PRIMARY KEY (PRODID,NUM) 	);

CREATE TABLE ACQUISTI (
	PRODID  CHAR(6) NOT NULL REFERENCES PRODOTTI,
	DATA 	DATE NOT NULL,
	QTA 	INT NOT NULL CHECK (QTA > 0),
	PRIMARY KEY (PRODID,DATA)     );

INSERT INTO PRODOTTI VALUES
('P11111','panca 3 posti legno'),
('P12222','panchina 2 posti in acciaio')
;

INSERT INTO LISTINO VALUES
('P11111',1,'14.06.2019',158.00),
('P11111',2,'18.10.2019',147.00),
('P11111',3,'25.05.2020',163.00),
('P11111',4,'19.11.2020',125.00),
('P12222',1,'20.09.2019',198.50),
('P12222',2,'06.04.2020',172.50),
('P12222',3,'20.12.2020',163.00)
;


INSERT INTO ACQUISTI VALUES
('P11111','17.07.2019',4),
('P11111','19.07.2019',2),
('P11111','15.12.2019',10),
('P11111','19.11.2020',8),
('P12222','04.03.2020',6),
('P12222','07.09.2020',11)
;

GRANT SELECT ON PRODOTTI TO PUBLIC;
GRANT SELECT ON LISTINO TO PUBLIC;
GRANT SELECT ON ACQUISTI TO PUBLIC;

-- 2.1)
-- Per ogni prodotto, il numero massimo di giorni in cui il prezzo non  variato
--    (per semplicit si ignori il periodo che include la data attuale)

SELECT	L1.ProdID, MAX(DAYS(L2.Data)-DAYS(L1.Data)) AS NumMaxGiorni
FROM	LISTINO L1, LISTINO L2
WHERE	L1.ProdID = L2.ProdID
AND	L2.Num = L1.Num + 1
GROUP BY L1.ProdID;


-- 2.2)
-- Il prodotto che ha complessivamente incassato di pi

WITH PRODTOTINC (ProdID,TotIncassi) AS (
		SELECT L.ProdID, SUM(L.Prezzo*I.Qta)
		FROM	 LISTINO L, ACQUISTI I
		WHERE	 L.ProdID = I.ProdID
		AND	 I.Data >= L.Data
		AND NOT EXISTS (	SELECT	*
					FROM	LISTINO L1
					WHERE	L1.Data > L.Data
					AND	L1.Data <= I.Data  )
		GROUP BY L.ProdID		)
SELECT *
FROM   PRODTOTINC P
WHERE  P.TotIncassi >= ALL ( SELECT P1.TotIncassi
	      		     FROM   PRODTOTINC P1    );





