DROP TABLE PRODOTTI;
DROP TABLE LISTINI;
DROP TABLE ACQUISTI;

CREATE TABLE PRODOTTI (
	PRODID 		CHAR(6) NOT NULL PRIMARY KEY,
	DESCRIZIONE	VARCHAR(30) NOT NULL		);

CREATE TABLE LISTINI (
	NUML 	INT NOT NULL CHECK (NUML > 0),
	PRODID 	CHAR(6) NOT NULL REFERENCES PRODOTTI,
	DATA 	DATE NOT NULL,
	PREZZO 	DEC(8,2) NOT NULL CHECK (PREZZO > 0),
	PRIMARY KEY (NUML,PRODID) 	);

CREATE TABLE ACQUISTI (
	NUML 	INT NOT NULL,
	PRODID  CHAR(6) NOT NULL ,
	DATA 	DATE NOT NULL,
	QTA 	INT NOT NULL CHECK (QTA > 0),
	PRIMARY KEY (NUML,PRODID,DATA),
	FOREIGN KEY (NUML,PRODID) REFERENCES LISTINI     );

INSERT INTO PRODOTTI VALUES
('P11111','panca 3 posti legno'),
('P12222','panchina 2 posti in acciaio'),
('P13333','divano da giardino 2 posti')
;

INSERT INTO LISTINI VALUES
(1,'P11111','14.06.2019',158.00),
(1,'P12222','14.06.2019',198.50),
(1,'P13333','14.06.2019',318.00),
--
(2,'P11111','18.10.2019',147.00),
(2,'P12222','18.10.2019',152.50),
(2,'P13333','18.10.2019',245.00),
--
(3,'P11111','25.05.2020',163.00),
(3,'P12222','25.05.2020',183.00),
(3,'P13333','25.05.2020',275.00)
;


INSERT INTO ACQUISTI VALUES
(1,'P11111','17.07.2019',4),
(1,'P11111','19.08.2019',3),
(2,'P11111','15.12.2019',10),
(3,'P11111','19.06.2020',4),
--
(1,'P12222','18.07.2019',6),
(2,'P12222','13.12.2019',6),
(3,'P12222','25.05.2020',8),
--
(1,'P13333','15.06.2019',2),
(1,'P13333','18.06.2019',2),
(2,'P13333','05.11.2019',2),
(2,'P13333','08.11.2019',2),
(3,'P13333','17.06.2020',4)
;

GRANT SELECT ON PRODOTTI TO PUBLIC;
GRANT SELECT ON LISTINI TO PUBLIC;
GRANT SELECT ON ACQUISTI TO PUBLIC;

-- 2.1)
-- Per ogni prodotto (completo di descrizione) i listini in cui le vendite del prodotto sono state 
-- complessivamente pi di 5 unit nei primi 60 giorni di validit del listino

SELECT	L.ProdID, P.Descrizione, L.NumL
FROM	LISTINI L JOIN PRODOTTI P ON (L.ProdID = P.ProdID)
WHERE	(L.NumL,L.ProdID) IN 
  (	SELECT 	A.NumL,A.ProdID
	FROM	ACQUISTI A
	WHERE	DAYS(A.Data) - DAYS(L.Data) < 60
	GROUP BY A.NumL,A.ProdID
	HAVING	SUM(A.Qta) > 5 );


-- 2.2)
-- Considerando solo i prodotti che per un dato listino hanno incassato complessivamente 
-- pi di 1000, il listino in cui il numero di tali prodotti  massimo

WITH PIUDI1000 (NumL,ProdID) AS (
		SELECT 	L.NumL, L.ProdID
		FROM	LISTINI L, ACQUISTI A
		WHERE	(L.NumL,L.ProdID) = (A.NumL,A.ProdID)
		GROUP BY L.NumL,L.ProdID
		HAVING	SUM(L.Prezzo*A.Qta) > 1000 ),
	NUMPRODOTTI (NumL,NumProd) AS (
		SELECT	NumL, COUNT(*)
		FROM	PIUDI1000
		GROUP BY NumL )
SELECT *
FROM   NUMPRODOTTI N
WHERE  N.NumProd >= ALL ( SELECT N1.NumProd
	      		     	  FROM   NUMPRODOTTI N1    );





