DROP TABLE CORRIDORI;
DROP TABLE PUNTI;
DROP TABLE ARRIVI;

CREATE TABLE CORRIDORI (
	NUM 		INT NOT NULL PRIMARY KEY,
	NOME		VARCHAR(30) NOT NULL,
	SQUADRA 	VARCHAR(20) NOT NULL		);

CREATE TABLE PUNTI (
	POS 	INT NOT NULL PRIMARY KEY CHECK (POS BETWEEN 1 AND 3),
	PUNTI	INT NOT NULL CHECK (PUNTI > 0)	);

CREATE TABLE ARRIVI (
	TAPPA   INT NOT NULL,
	POS  	INT NOT NULL CHECK (POS > 0),
	NUMCORRIDORE INT NOT NULL REFERENCES CORRIDORI,
	TEMPO	TIME NOT NULL CHECK (TEMPO > '00:00:00'),
	PRIMARY KEY (TAPPA,POS)		     );

INSERT INTO CORRIDORI VALUES
(1,'Topolino','topivelox'),
(2,'Minnie','topivelox'),
(3,'Pippo','topivelox'),
(4,'Gambadilegno','topivelox'),
(5,'Paperino','duckbikes'),
(6,'Gastone','duckbikes'),
(7,'Paperoga','duckbikes'),
(8,'Paperina','duckbikes')
;

INSERT INTO PUNTI VALUES
(1,10),
(2,5),
(3,2)
;

INSERT INTO ARRIVI VALUES
(1,1,3,'02:15:36'),
(1,2,6,'02:15:47'),
(1,3,2,'02:16:21'),
(1,4,4,'02:16:22'),
(1,5,1,'02:18:05'),
(1,6,7,'02:20:15'),
--
(2,1,8,'03:02:16'),
(2,2,5,'03:03:05'),
(2,3,1,'03:03:58'),
(2,4,4,'03:04:06'),
(2,5,3,'03:04:07'),
--
(3,1,2,'03:14:47'),
(3,2,6,'03:15:25'),
(3,3,7,'03:16:00'),
(3,4,1,'03:16:59'),
(3,5,4,'03:24:07'),
(3,6,5,'02:30:15')
;

GRANT SELECT ON CORRIDORI TO PUBLIC;
GRANT SELECT ON PUNTI TO PUBLIC;
GRANT SELECT ON ARRIVI TO PUBLIC;

-- 2.1)
-- Per ogni corridore, il numero, il nome, i punti totali (0 se non ha punti) 
-- e la miglior posizione ottenuta, ordinando per valori decrescenti dei primi 
-- e, a parit, per valori crescenti della seconda

SELECT	C.Num, C.Nome, COALESCE(SUM(P.Punti),0) AS PuntiTotali, MIN(A.Pos) AS MigliorPosizione
FROM	ARRIVI A LEFT JOIN PUNTI P ON (A.POS = P.POS) 
			JOIN CORRIDORI C ON (A.NumCorridore = C.Num)
GROUP BY C.Num, C.Nome
ORDER BY PuntiTotali DESC, MigliorPosizione;

-- 2.2)
-- Considerando solo le prime 3 posizioni in ogni tappa, 
-- i dati del corridore che ha dato il maggior distacco di tempo al successivo

WITH DISTACCHI(NumCorridore,Distacco)
AS (SELECT	A1.NumCorridore, A2.Tempo - A1.Tempo
	FROM	ARRIVI A1, ARRIVI A2	
	WHERE	A1.Pos + 1 = A2.Pos
	AND		A2.Pos <= 3
	AND		A1.Tappa = A2.Tappa)
SELECT  C.*
FROM	CORRIDORI C, DISTACCHI D
WHERE	C.Num = D.NumCorridore
AND		D.Distacco = (	SELECT 	MAX(Distacco)
						FROM	DISTACCHI ); 





