DROP TABLE SEZIONI;
DROP TABLE RISULTATI;

CREATE TABLE SEZIONI (
	NUM 		INT NOT NULL PRIMARY KEY CHECK(NUM > 0),
	NELETTORI	INT NOT NULL CHECK(NELETTORI > 0)		);

CREATE TABLE RISULTATI (
	NUMSEZIONE 	INT NOT NULL REFERENCES SEZIONI,
	PARTITO		CHAR(5) NOT NULL,
	VOTI			INT NOT NULL CHECK(VOTI >= 0)		);

INSERT INTO SEZIONI VALUES
(1,600),
(2,550),
(3,400)
;

INSERT INTO RISULTATI VALUES
(1,'ABC',305),
(1,'DEF',170),
(1,'GHI',80),
(2,'ABC',210),
(2,'DEF',240),
(2,'GHI',50),
(3,'ABC',185),
(3,'DEF',120),
(3,'GHI',60)
;

GRANT SELECT ON SEZIONI TO PUBLIC;
GRANT SELECT ON RISULTATI TO PUBLIC;

-- 2.1)
-- Per ogni partito, le sezioni in cui quel partito ha ottenuto un numero di voti 
-- maggiore della somma dei voti di tutti gli altri partiti

SELECT	R.Partito, R.NumSezione
FROM	RISULTATI R
WHERE 	R.Voti >= (	SELECT	SUM(R1.Voti)
				   	FROM 	RISULTATI R1
					WHERE 	R1.NumSezione = R.NumSezione
					AND		R1.Partito <> R.Partito) ;

-- 2.2)
-- La sezione in cui il numero di voti validi  stato il maggiore in percentuale 
-- rispetto al numero di elettori in quella sezione

WITH PERC_VALIDI(NumSezione,Perc) AS (
	SELECT	R.NumSezione, DEC(SUM(R.Voti)*1.0/S.NElettori,4,3)
	FROM	RISULTATI R, SEZIONI S
	WHERE 	R.NumSezione = S.Num
	GROUP BY R.NumSezione,S.NElettori )
SELECT	*
FROM	PERC_VALIDI P
WHERE	P.Perc >= (	SELECT	MAX(P1.Perc)
					FROM	PERC_VALIDI P1);


