DROP TABLE MEDICI;
DROP TABLE TERAPIE;
DROP TABLE VISITE;

CREATE TABLE MEDICI (
	MID 	CHAR(3) NOT NULL PRIMARY KEY,
	NOME	VARCHAR(30) NOT NULL 		);

CREATE TABLE TERAPIE (
	TID 		CHAR(5) NOT NULL PRIMARY KEY,
	PAZIENTE 	VARCHAR(30) NOT NULL,
	IMPORTO	DEC(8,2) NOT NULL CHECK (IMPORTO > 0) 		);

CREATE TABLE VISITE (
	TID 	CHAR(5) NOT NULL REFERENCES TERAPIE,
	DATA	DATE NOT NULL,
	MID 	CHAR(3) NOT NULL REFERENCES MEDICI,
	PRIMARY KEY (TID,DATA)				);

INSERT INTO MEDICI VALUES
('M01','Reni'),
('M02','Corelli'),
('M03','Ortani')
;

INSERT INTO TERAPIE VALUES
('T0111','Rossi',100), 
('T0121','Verdi',1200), 
('T1123','Rossi',150), 
('T1234','Bianchi',600), 
('T1333','Neri',2500),
('T1515','Rossi',3000)
;


INSERT INTO VISITE VALUES
('T0111','12.09.2020','M02'),
('T0121','10.11.2020','M01'),
('T0121','09.01.2021','M03'),
('T1123','10.03.2021','M03'),
('T1123','16.03.2021','M03'),
('T1123','14.04.2021','M03'),
('T1234','21.06.2021','M01'),
('T1234','27.07.2021','M01'),
('T1234','28.09.2021','M01'),
('T1333','10.09.2021','M02'),
('T1515','15.09.2021','M01'),
('T1515','25.09.2021','M02')
;

GRANT SELECT ON TABLE MEDICI TO PUBLIC;
GRANT SELECT ON TABLE TERAPIE TO PUBLIC;
GRANT SELECT ON TABLE VISITE TO PUBLIC;


-- 2.1 
-- I nomi dei medici che nel 2021 hanno eseguito almeno 3 visite 
-- per una stessa terapia di importo maggiore di 500
SELECT 	M.Nome
FROM   	MEDICI M
WHERE	M.MID IN
		( SELECT 	V.MID
		  FROM	TERAPIE T, VISITE V
		  WHERE  	T.TID = V.TID
		  AND		T.Importo > 500		
		  AND		YEAR(V.Data) = 2021		
		  GROUP BY  V.MID, V.TID
		  HAVING	COUNT(*) >= 3  )	;

		 
-- 2.2
-- I dati della terapia di importo massimo, considerando solo le terapie 
-- in cui tutte le visite (almeno 2) sono state con uno stesso medico
WITH TERAPIE_UN_MEDICO(TID) AS (
	SELECT   V.TID
	FROM	 VISITE V
	GROUP BY V.TID 
	HAVING   COUNT(*) > 1 AND COUNT(DISTINCT V.MID) = 1 )
SELECT 	T.* 
FROM	TERAPIE T, TERAPIE_UN_MEDICO TUM
WHERE  	T.TID = TUM.TID
AND		T.Importo = ( SELECT MAX(T1.Importo)
				   FROM   TERAPIE T1, TERAPIE_UN_MEDICO TUM1
  				   WHERE  T1.TID = TUM1.TID ) ;
  						
TID   |PAZIENTE |IMPORTO |
------|---------|--------|
T1234 |Bianchi  |600.00  |
