DROP TABLE PIZZE;
DROP TABLE ORDINI;
DROP TABLE DETTAGLI;

CREATE TABLE PIZZE (
	NOME	VARCHAR(20) NOT NULL PRIMARY KEY,
	PREZZO	DEC(6,2) NOT NULL CHECK (PREZZO > 0)	);

CREATE TABLE ORDINI (
	OID 	CHAR(5) NOT NULL PRIMARY KEY,
	DATA 	DATE NOT NULL,
	IMPORTO	DEC(6,2) NOT NULL CHECK (IMPORTO > 0),
	CLIENTE	VARCHAR(30) NOT NULL		);

CREATE TABLE DETTAGLI (
	OID 	CHAR(5) NOT NULL REFERENCES ORDINI,
	NOME 	VARCHAR(20) NOT NULL REFERENCES PIZZE,
	QTA 	INT NOT NULL CHECK (QTA > 0),
	PRIMARY KEY (OID,NOME)     			);

INSERT INTO PIZZE VALUES
('Marinara',4.50),
('Margherita',5.50),
('4 stagioni',7.00),
('Bufala',6.50),
('Calzone',7.50)
;

INSERT INTO ORDINI VALUES
('O1111','21.12.2021',30,'Paperino'),
('O1115','27.12.2021',50,'Paperino'),
('O1125','21.01.2022',22.50,'Paperino'),
('O1136','24.01.2022',14,'Paperino'),
--
('O2114','20.12.2021',33,'Pippo'),
('O2317','07.01.2022',43,'Pippo'),
('O2421','10.01.2022',62,'Pippo')
;


INSERT INTO DETTAGLI VALUES
('O1111','Calzone',4),
('O1115','Calzone',3),
('O1115','Bufala',3),
('O1115','Margherita',3),
('O1125','Margherita',2),
('O1125','Marinara',1),
('O1125','4 stagioni',1),
('O1136','4 stagioni',2),
--
('O2114','Margherita',6),
('O2317','Margherita',4),
('O2317','4 stagioni',3),
('O2421','Marinara',15)
;

GRANT SELECT ON PIZZE TO PUBLIC;
GRANT SELECT ON ORDINI TO PUBLIC;
GRANT SELECT ON DETTAGLI TO PUBLIC;


-- 2.1)
-- Per ogni ordine di importo superiore ai 40 
-- e in cui  stato applicato uno sconto, limporto di tale sconto

SELECT	O.OID, (SUM(D.QTA*P.PREZZO) - O.IMPORTO) AS SCONTO
FROM 	ORDINI O, DETTAGLI D, PIZZE P
WHERE 	O.OID = D. OID
AND 	D.NOME = P.NOME
AND 	O.IMPORTO > 40
GROUP BY O.OID, O.IMPORTO
HAVING 	 SUM(D.QTA*P.PREZZO) > O.IMPORTO;

-- 2.2)
-- Considerando solo gli ordini di almeno 3 pizze, non tutte uguali, 
-- lordine e il relativo cliente in cui, considerando limporto pagato, 
-- il costo medio di una pizza  stato massimo

WITH ORDINI3 (OID,CLIENTE,COSTOMEDIO) AS (
	SELECT	O.OID,O.CLIENTE,DEC(O.IMPORTO/SUM(D.QTA),6,2)
	FROM 	ORDINI O, DETTAGLI D
	WHERE 	O.OID = D. OID
	GROUP BY O.OID, O.IMPORTO, O.CLIENTE
	HAVING 	 SUM(D.QTA) >= 3
	   AND   COUNT(*) > 1
)
SELECT	*
FROM	ORDINI3 O
WHERE 	O.COSTOMEDIO >= ALL ( SELECT O1.COSTOMEDIO
							  FROM   ORDINI3 O1 );





