DROP TABLE PIZZE;
DROP TABLE ORDINI;
DROP TABLE DETTAGLI;

CREATE TABLE PIZZE (
	NOME	VARCHAR(20) NOT NULL PRIMARY KEY,
	PREZZO	DEC(6,2) NOT NULL CHECK (PREZZO > 0)	);

CREATE TABLE ORDINI (
	OID 	CHAR(5) NOT NULL PRIMARY KEY,
	DATA 	DATE NOT NULL,
	IMPORTO	DEC(6,2) NOT NULL CHECK (IMPORTO > 0),
	CLIENTE	VARCHAR(30) NOT NULL,
	UNIQUE (CLIENTE,DATA) 			);

CREATE TABLE DETTAGLI (
	OID 	CHAR(5) NOT NULL REFERENCES ORDINI,
	NOME 	VARCHAR(20) NOT NULL REFERENCES PIZZE,
	QTA 	INT NOT NULL CHECK (QTA > 0),
	PRIMARY KEY (OID,NOME)     			);

INSERT INTO PIZZE VALUES
('Marinara',4.50),
('Margherita',5.50),
('4 stagioni',7.00),
('Bufala',6.50),
('Calzone',7.50)
;

INSERT INTO ORDINI VALUES
('O1111','21.12.2021',40,'Paperino'),
('O1125','21.01.2022',27,'Paperino'),
('O1136','27.01.2022',25,'Paperino'),
--
('O2111','21.12.2021',33,'Pippo'),
('O2317','07.01.2022',43,'Pippo'),
('O2421','10.01.2022',17,'Pippo'),
('O2536','27.01.2022',25.50,'Pippo'),
--
('O3214','20.12.2021',33,'Topolino'),
('O3417','07.01.2022',45,'Topolino'),
('O3536','27.01.2022',36,'Topolino')
;


INSERT INTO DETTAGLI VALUES
('O1111','Calzone',4),
('O1111','Margherita',2),
('O1125','Calzone',3),
('O1125','Marinara',1),
('O1136','Margherita',2),
('O1136','4 stagioni',2),
--
('O2111','Margherita',6),
('O2317','Margherita',4),
('O2317','4 stagioni',3),
('O2421','Marinara',4),
('O2536','4 stagioni',3),
('O2536','Marinara',1),
--
('O3214','Margherita',6),
('O3417','Bufala',7),
('O3536','Margherita',3),
('O3536','Bufala',3)
;


GRANT SELECT ON PIZZE TO PUBLIC;
GRANT SELECT ON ORDINI TO PUBLIC;
GRANT SELECT ON DETTAGLI TO PUBLIC;


-- 2.1)
-- Per ogni cliente, le pizze che ha ordinato 
-- almeno 2 volte di seguito (ossia in ordini consecutivi)

SELECT	DISTINCT O1.CLIENTE, D1.NOME AS PIZZA, O1.OID, O2.OID
FROM 	ORDINI O1, ORDINI O2, DETTAGLI D1, DETTAGLI D2
WHERE 	O1.CLIENTE = O2.CLIENTE	-- stesso cliente
AND		O1.DATA < O2.DATA		-- ordini diversi, O1 fatto prima
AND		O1.OID = D1. OID
AND		O2.OID = D2.OID
AND		D1.NOME = D2.NOME		-- stessa pizza
AND		NOT EXISTS (SELECT * 	-- ordini consecutivi
					FROM	ORDINI O
					WHERE 	O.CLIENTE = O1.CLIENTE
					AND		O1.DATA < O.DATA
					AND		O.DATA < O2.DATA);

-- 2.2)
-- Le coppie di clienti che, ogni volta che hanno fatto un ordine lo stesso giorno, 
-- hanno sempre preso lo stesso numero totale di pizze

WITH NUMPIZZE (CLIENTE,DATA,TOTPIZZE) AS (
	SELECT	O.CLIENTE,O.DATA,SUM(D.QTA)
	FROM 	ORDINI O, DETTAGLI D
	WHERE 	O.OID = D. OID
	GROUP BY O.CLIENTE, O.DATA
)
SELECT	N1.CLIENTE AS CLIENTE1, N2.CLIENTE AS CLIENTE2
FROM	NUMPIZZE N1, NUMPIZZE N2
WHERE 	N1.CLIENTE < N2.CLIENTE
AND		N1.DATA = N2.DATA
	EXCEPT
SELECT	N1.CLIENTE AS CLIENTE1, N2.CLIENTE AS CLIENTE2
FROM	NUMPIZZE N1, NUMPIZZE N2
WHERE 	N1.CLIENTE < N2.CLIENTE
AND		N1.DATA = N2.DATA
AND		N1.TOTPIZZE <> N2.TOTPIZZE;






