DROP TABLE FATTURE;
DROP TABLE RATE;

CREATE TABLE FATTURE (
	NUMF	INT NOT NULL PRIMARY KEY,
	DATA	DATE NOT NULL,
	IMPORTO	DEC(8,2) NOT NULL CHECK (IMPORTO > 0),
	CLIENTE	VARCHAR(30) NOT NULL,
	NUMERORATE INT NOT NULL CHECK (NUMERORATE > 1));

CREATE TABLE RATE (
	NUMF 	INT NOT NULL REFERENCES FATTURE,
	NUMRATA INT NOT NULL CHECK (NUMRATA >= 1),
	IMPORTORATA DEC(8,2) NOT NULL CHECK (IMPORTORATA > 0),
	DAPAGAREENTRO DATE NOT NULL,
	PAGATAIL DATE,
	PRIMARY KEY (NUMF,NUMRATA)     			);

INSERT INTO FATTURE VALUES
(101,'14.06.2021',3500,'Pippo',3),
(105,'18.08.2021',5000,'Pippo',2),
(206,'24.07.2021',10500,'Paperino',4),
(246,'28.10.2021',1500,'Paperino',2),
(258,'21.12.2021',4000,'Paperino',3)
;

INSERT INTO RATE VALUES
(101,1,1000,'24.06.2021','24.06.2021'),
(101,2,1000,'24.12.2021','31.12.2021'),
(101,3,1500,'24.01.2022',NULL),
--
(105,1,2000,'18.10.2021','20.10.2021'),
(105,2,2000,'18.01.2022','20.01.2022'),
--
(206,1,2500,'23.09.2021','10.10.2021'),
(206,2,2500,'23.11.2021','25.11.2021'),
(206,3,2500,'23.01.2022','10.01.2022'),
(206,4,3000,'23.03.2021',NULL),
--
(246,1,500,'10.11.2021','10.11.2021'),
(246,2,1000,'10.12.2021','10.12.2021'),
--
(258,1,2000,'13.01.2022','13.01.2022'),
(258,2,1000,'13.02.2022','18.02.2022'),
(258,3,1000,'13.03.2022',NULL)
;


GRANT SELECT ON FATTURE TO PUBLIC;
GRANT SELECT ON RATE TO PUBLIC;


-- 2.1)
-- Per ogni cliente la percentuale di rate pagate, 
-- considerando solo le fatture non completamente pagate

SELECT 	F.Cliente, 
	 DEC(COUNT(R.PagataIl)*100.0/COUNT(*),4,2) AS PERC_PAGATE
FROM	FATTURE F, RATE R
WHERE	F.NumF = R.NumF
AND	 	F.NumF IN ( SELECT R1.NumF 
			  		FROM   RATE R1
			  		WHERE  R1.PagataIl IS NULL )
GROUP BY F.Cliente ; 

-- 2.2)
-- I dati della fattura in cui, considerando solo le rate 
-- pagate in ritardo, la media dei giorni di ritardato 
-- pagamento  stata massima

WITH RITARDI (NumF,RitardoMedio) AS (
 SELECT R.NumF, 
   DEC(AVG((DAYS(R.PagataIl)-DAYS(R.DaPagareEntro))*1.0),6,2)
 FROM  RATE R
 WHERE R.PagataIl > R.DaPagareEntro
 GROUP BY R.NumF					)
SELECT 	F.*,R.RitardoMedio
FROM	FATTURE F, RITARDI R
WHERE  	F.NumF = R.NumF
AND	 	R.RitardoMedio = ( 	SELECT 	MAX(R1.RitardoMedio)
				    		FROM  	RITARDI R1 )         ; 






