DROP TABLE REPARTI;
DROP TABLE DIPENDENTI;
DROP TABLE PROGETTI;

CREATE TABLE REPARTI (
	CODR	CHAR(5) NOT NULL PRIMARY KEY,
	NOME	VARCHAR(30) NOT NULL,
	DIRETTORE CHAR(5) NOT NULL 		);

CREATE TABLE DIPENDENTI (
	DID	CHAR(5) NOT NULL PRIMARY KEY,
	NOME	VARCHAR(30) NOT NULL,
	STIPENDIO	DEC(8,2) NOT NULL CHECK (STIPENDIO > 0),
	REPARTO CHAR(5) NOT NULL REFERENCES REPARTI		);

CREATE TABLE PROGETTI (
	CODPROG CHAR(5)	NOT NULL PRIMARY KEY,
	TITOLO VARCHAR(30) NOT NULL,
	BUDGET DEC(8,2) NOT NULL CHECK (BUDGET > 0),
	RESPONSABILE CHAR(5) NOT NULL REFERENCES DIPENDENTI	);

INSERT INTO REPARTI VALUES
('R0001','TECH 1','D0020'),
('R0002','TECH 2','D0020'),
('R0003','MKT 1','D0030'),
('R0004','MKT 2','D0031'),
('R0005','ADV','D0050')
;

INSERT INTO DIPENDENTI VALUES
('D0010','Luca',1850,'R0001'),
('D0011','Anna',2150,'R0001'),
('D0012','Ada',2250,'R0001'),
--
('D0020','Paperina',4500,'R0002'),
('D0021','Ciccio',1500,'R0002'),
('D0022','Paperino',2500,'R0002'),
--
('D0030','Homer',3270,'R0003'),
('D0031','Lisa',5000,'R0003'),
('D0032','Bart',1620,'R0003'),
--
('D0040','Topolino',3520,'R0004'),
('D0041','Pippo',2450,'R0004'),
--
('D0050','IronMan',5120,'R0005'),
('D0051','SpiderMan',2150,'R0005')
;

ALTER TABLE REPARTI
ADD CONSTRAINT FK_DIR FOREIGN KEY (DIRETTORE) REFERENCES DIPENDENTI;

INSERT INTO PROGETTI VALUES
('P0001','AABBCC',180000,'D0010'),
('P0002','BBCCDD',240000,'D0022'),
('P0003','CCDDEE',280000,'D0022'),
('P0004','DDEEFF',500000,'D0031'),
('P0005','EEFFGG',220000,'D0031'),
('P0006','FFGGHH',120000,'D0040'),
('P0007','GGHHII',100000,'D0040'),
('P0008','HHIILL',300000,'D0050')
;

GRANT SELECT ON REPARTI TO PUBLIC;
GRANT SELECT ON DIPENDENTI TO PUBLIC;
GRANT SELECT ON PROGETTI TO PUBLIC;



-- 2.1)
-- Per ogni reparto la somma degli stipendi dei dipendenti, 
-- escludendo i dipendenti responsabili di progetto e/o 
-- direttori di reparto

SELECT	R.CodR, SUM(D.Stipendio) AS SommaStipendi 
FROM 	REPARTI R, DIPENDENTI D
WHERE 	D.Reparto = R.CodR
AND	D.DID NOT IN ( SELECT P.Responsabile 
			    FROM   PROGETTI P
					UNION
			    SELECT R1.Direttore 
			    FROM   REPARTI R1
 				  )
GROUP BY R.CodR ; 

-- 2.2)
-- Il reparto che ha come direttore un dipendente di un altro 
-- reparto e per il quale la somma dei budget dei progetti 
-- ad esso afferenti  massima

WITH 
ALTROREP(CodR) AS (
		SELECT R.CodR 
		FROM 	 REPARTI R, DIPENDENTI D
		WHERE  R.Direttore = D.DID
		AND	 D.Reparto <> R.CodR  ),
SUMBUDGET (CodR,TotBudget) AS (
		SELECT R.CodR, SUM(P.Budget)
		FROM 	 REPARTI R, DIPENDENTI D, PROGETTI P
		WHERE  D.Reparto = R.CodR
	  	AND	 D.DID = P.Responsabile
	  	AND	 R.CodR IN ( SELECT CodR
					  FROM   ALTROREP )
		GROUP BY R.CodR					)
SELECT	S.*
FROM		SUMBUDGET S
WHERE 	S.TotBudget = ( SELECT MAX(S1.TotBudget)
				    	FROM   SUMBUDGET S1 	); 
