DROP TABLE CLIENTI;
DROP TABLE ACQUISTI;
DROP TABLE RATE;

CREATE TABLE CLIENTI (
	NOME 	 VARCHAR(30) NOT NULL PRIMARY KEY,
	TOTSPESE DEC(8,2) NOT NULL			);

CREATE TABLE ACQUISTI (
	IDA		CHAR(5) NOT NULL PRIMARY KEY,
	CLIENTE	VARCHAR(30) NOT NULL REFERENCES CLIENTI,
	IMPORTO	DEC(8,2) NOT NULL CHECK (IMPORTO > 0),
	NUMRATE INT NOT NULL CHECK (NUMRATE > 1) 		);

CREATE TABLE RATEPAGATE (
	IDA CHAR(5)	NOT NULL REFERENCES ACQUISTI,
	DATA DATE NOT NULL,
	IMPORTORATA DEC(8,2) NOT NULL CHECK (IMPORTORATA > 0),
	PRIMARY KEY (IDA,DATA)									);

INSERT INTO CLIENTI VALUES
('Archimede',8000),
('Pippo',5000),
('Topolino',15000)
;

INSERT INTO ACQUISTI VALUES
('A0001','Archimede',6000,3),
('A0002','Archimede',2000,2),
--
('P0001','Pippo',1500,4),
('P0002','Pippo',1000,2),
('P0003','Pippo',2500,5),
--
('T0001','Topolino',4000,2),
('T0002','Topolino',3500,3),
('T0003','Topolino',7500,4)
;

INSERT INTO RATEPAGATE VALUES
('A0001','14.01.2022',2000),
('A0001','14.03.2022',2000),
('A0002','15.02.2022',1500),
--
('P0001','07.02.2022',300),
('P0001','07.03.2022',350),
('P0001','07.04.2022',300),
('P0002','06.05.2022',500),
('P0003','10.06.2022',500),
('P0003','10.07.2022',800),
('P0003','10.09.2022',1200),
--
('T0001','01.04.2022',1000),
('T0001','15.05.2022',3000),
('T0002','01.06.2022',2000),
('T0003','01.04.2022',2000),
('T0003','01.06.2022',2500)
;

GRANT SELECT ON CLIENTI TO PUBLIC;
GRANT SELECT ON ACQUISTI TO PUBLIC;
GRANT SELECT ON RATEPAGATE TO PUBLIC;



-- 2.1)
-- I nomi dei clienti che hanno un totale spese maggiore di 5000 
-- e che hanno fatto almeno un acquisto di 3 o pi rate 
-- in cui limporto delle rate pagate (almeno 2)  sempre aumentato,
-- riportando in output anche l'identificativo dell'acquisto

SELECT	C.NOME, A.IDA 
FROM	CLIENTI C, ACQUISTI A
WHERE 	C.NOME = A.CLIENTE 
AND 	C.TOTSPESE > 5000
AND 	A.NUMRATE >= 3
AND 	NOT EXISTS ( SELECT *  -- rata uguale o diminuita
					 FROM	RATEPAGATE R1, RATEPAGATE R2
					 WHERE	R1.IDA = R2.IDA
					 AND	A.IDA = R1.IDA
					 AND	R1.DATA < R2.DATA
					 AND	R1.IMPORTORATA >= R2.IMPORTORATA)
AND 	2 <= ( 	SELECT 	COUNT(*) -- almeno 2 rate pagate
				FROM 	RATEPAGATE R
				WHERE 	R.IDA = A.IDA ) ;

-- 2.2)
-- Considerando solo gli acquisti per cui sono state pagate 
-- almeno 2 rate, lidentificativo dellacquisto 
-- e il relativo cliente per cui il tempo trascorso 
-- tra una rata e la successiva  stato massimo

WITH MAXTEMPO(IDA, NUMGIORNI) AS 
(SELECT	R1.IDA, MAX(DAYS(R2.DATA)-DAYS(R1.DATA))
 FROM 	RATEPAGATE R1, RATEPAGATE R2 
 WHERE 	R1.IDA = R2.IDA			-- stesso acquisto 
 AND	R1.DATA < R2.DATA	
 AND	NOT EXISTS (SELECT	* 	-- rate consecutive
					FROM	RATEPAGATE R
					WHERE 	R.IDA = R1.IDA
					AND		R1.DATA < R.DATA
					AND		R.DATA < R2.DATA)
 GROUP BY R1.IDA	)
SELECT  A.IDA, A.CLIENTE, M1.NUMGIORNI
FROM	MAXTEMPO M1, ACQUISTI A
WHERE 	M1.IDA = A.IDA
AND 	M1.NUMGIORNI = ( SELECT MAX(M2.NUMGIORNI)
						 FROM	MAXTEMPO M2 )		;