/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.IndexAVLMemory;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.DbBackup;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LockFile;
import org.hsqldb.persist.Log;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.persist.RowStoreAVLDiskData;
import org.hsqldb.persist.RowStoreAVLHybrid;
import org.hsqldb.persist.RowStoreAVLHybridExtended;
import org.hsqldb.persist.RowStoreAVLMemory;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class Logger {
    public SimpleLog appLog;
    public SimpleLog sqlLog;
    FrameworkLogger fwLogger;
    FrameworkLogger sqlLogger;
    private Database database;
    public boolean checkpointRequired;
    public boolean checkpointDue;
    public boolean checkpointDisabled;
    private boolean logsStatements;
    private boolean loggingEnabled;
    private boolean syncFile = false;
    boolean propIsFileDatabase;
    boolean propFilesReadOnly;
    boolean propDatabaseReadOnly;
    boolean propIncrementBackup;
    boolean propNioDataFile;
    long propNioMaxSize = 0x10000000L;
    int propMaxFreeBlocks;
    int propCacheMaxRows;
    int propCacheMaxSize;
    int propCacheFileScale;
    int propCacheDefragLimit;
    String propTextSourceDefault = "";
    boolean propTextAllowFullPath;
    int propWriteDelay;
    int propLogSize;
    boolean propLogData = true;
    int propEventLogLevel;
    int propSqlLogLevel;
    int propGC;
    int propTxMode = 0;
    boolean propRefIntegrity = true;
    int propLobBlockSize = 32768;
    int propScriptFormat = 0;
    Log log;
    private LockFile lockFile;
    private Crypto crypto;
    public FileAccess fileAccess;
    public boolean isStoredFileAccess;
    String tempDirectoryPath;
    public boolean isNewDatabase;
    public boolean isSingleFile;
    public static final String oldFileExtension = ".old";
    public static final String newFileExtension = ".new";
    public static final String appLogFileExtension = ".app.log";
    public static final String sqlLogFileExtension = ".sql.log";
    public static final String logFileExtension = ".log";
    public static final String scriptFileExtension = ".script";
    public static final String propertiesFileExtension = ".properties";
    public static final String dataFileExtension = ".data";
    public static final String backupFileExtension = ".backup";
    public static final String lobsFileExtension = ".lobs";
    public static final String lockFileExtension = ".lck";
    private static SimpleDateFormat backupFileFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private static Character runtimeFileDelim = null;

    public Logger(Database database) {
        this.database = database;
    }

    public void openPersistence() {
        boolean bl;
        String string = this.database.getURLProperties().getProperty("fileaccess_class_name");
        boolean bl2 = false;
        boolean bl3 = false;
        if (string != null) {
            String string2 = this.database.getURLProperties().getProperty("storage_key");
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(Object.class);
                this.fileAccess = (FileAccess)constructor.newInstance(string2);
                this.isStoredFileAccess = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("ClassNotFoundException");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("InstantiationException");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException");
            }
            catch (Exception exception) {
                System.out.println("Exception");
            }
        } else {
            this.fileAccess = FileUtil.getFileAccess(this.database.isFilesInJar());
        }
        this.propIsFileDatabase = DatabaseURL.isFileBasedDatabaseType(this.database.getType());
        this.database.databaseProperties = new HsqlDatabaseProperties(this.database);
        if (this.propIsFileDatabase) {
            boolean bl4;
            bl2 = this.database.databaseProperties.load();
            bl3 = this.fileAccess.isStreamElement(this.database.getPath() + scriptFileExtension);
            if (this.database.databaseProperties.isVersion18()) {
                bl4 = bl2;
            } else {
                bl4 = bl3;
                if (!bl4 && (bl4 = this.fileAccess.isStreamElement(this.database.getPath() + scriptFileExtension + newFileExtension))) {
                    this.database.databaseProperties.setDBModified(2);
                }
            }
            this.isNewDatabase = !bl4;
        } else {
            this.isNewDatabase = true;
        }
        if (this.isNewDatabase) {
            String string3 = this.newUniqueName();
            this.database.setUniqueName(string3);
            boolean bl5 = this.database.isFilesInJar();
            if (bl5 |= this.database.urlProperties.isPropertyTrue("ifexists") || !this.database.urlProperties.isPropertyTrue("create", true)) {
                throw Error.error(465, this.database.getPath());
            }
            this.database.databaseProperties.setURLProperties(this.database.urlProperties);
        } else {
            int n;
            if (!bl2) {
                this.database.databaseProperties.setDBModified(1);
            }
            if (this.database.urlProperties.isPropertyTrue("files_readonly")) {
                this.database.databaseProperties.setProperty("files_readonly", true);
            }
            if (this.database.urlProperties.isPropertyTrue("readonly")) {
                this.database.databaseProperties.setProperty("readonly", true);
            }
            if (!this.database.urlProperties.isPropertyTrue("hsqldb.lock_file", true)) {
                this.database.databaseProperties.setProperty("hsqldb.lock_file", false);
            }
            if ((n = this.database.urlProperties.getIntegerProperty("hsqldb.applog", 0)) > 0) {
                this.database.databaseProperties.setProperty("hsqldb.applog", n);
            }
            if ((n = this.database.urlProperties.getIntegerProperty("hsqldb.sqllog", 0)) > 0) {
                this.database.databaseProperties.setProperty("hsqldb.sqllog", n);
            }
        }
        this.setVariables();
        String string4 = null;
        String string5 = null;
        if (DatabaseURL.isFileBasedDatabaseType(this.database.getType()) && !this.database.isFilesReadOnly()) {
            string4 = this.database.getPath() + appLogFileExtension;
            string5 = this.database.getPath() + sqlLogFileExtension;
        }
        this.appLog = new SimpleLog(string4, this.propEventLogLevel);
        this.sqlLog = new SimpleLog(string5, this.propSqlLogLevel);
        this.database.setReferentialIntegrity(this.propRefIntegrity);
        if (!this.isFileDatabase()) {
            return;
        }
        this.checkpointRequired = false;
        this.logsStatements = false;
        boolean bl6 = this.database.getProperties().isPropertyTrue("hsqldb.lock_file");
        if (bl6 && !this.database.isFilesReadOnly()) {
            this.acquireLock(this.database.getPath());
        }
        if (bl = this.database.databaseProperties.isVersion18()) {
            this.database.setUniqueName(this.newUniqueName());
            if (!bl3) {
                this.database.schemaManager.createPublicSchema();
            }
        }
        this.log = new Log(this.database);
        this.log.open();
        this.logsStatements = true;
        boolean bl7 = this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        if (bl) {
            HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.findSchemaHsqlName("PUBLIC");
            if (hsqlName != null) {
                this.database.schemaManager.setDefaultSchemaHsqlName(hsqlName);
            }
            this.checkpoint(false);
        }
        if (this.database.getUniqueName() == null) {
            this.database.setUniqueName(this.newUniqueName());
        }
    }

    private void setVariables() {
        String string;
        String string2;
        String string3 = this.database.urlProperties.getProperty("crypt_key");
        if (string3 != null) {
            String string4 = this.database.urlProperties.getProperty("crypt_type");
            string2 = this.database.urlProperties.getProperty("crypt_provider");
            this.crypto = new Crypto(string3, string4, string2);
        }
        if (this.database.databaseProperties.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        if (this.database.databaseProperties.isPropertyTrue("files_readonly")) {
            this.database.setFilesReadOnly();
        }
        if (!this.database.isFilesReadOnly()) {
            this.tempDirectoryPath = this.database.getType() == "mem:" || this.isStoredFileAccess ? this.database.getProperties().getStringProperty("hsqldb.temp_directory") : this.database.getPath() + ".tmp";
            if (this.tempDirectoryPath != null) {
                this.tempDirectoryPath = FileUtil.makeDirectories(this.tempDirectoryPath);
            }
        }
        this.propScriptFormat = this.database.databaseProperties.getIntegerProperty("hsqldb.script_format");
        boolean bl = this.database.databaseProperties.isVersion18();
        if (!this.isNewDatabase && !bl) {
            return;
        }
        if (this.tempDirectoryPath != null) {
            int n = this.database.databaseProperties.getIntegerProperty("hsqldb.result_max_memory_rows");
            this.database.setResultMaxMemoryRows(n);
        }
        if ("CACHED".equalsIgnoreCase(string2 = this.database.databaseProperties.getStringProperty("hsqldb.default_table_type"))) {
            this.database.schemaManager.setDefaultTableType(5);
        }
        if ("MVCC".equalsIgnoreCase(string = this.database.databaseProperties.getStringProperty("hsqldb.tx"))) {
            this.propTxMode = 2;
        } else if ("MVLOCKS".equalsIgnoreCase(string)) {
            this.propTxMode = 1;
        } else if ("LOCKS".equalsIgnoreCase(string)) {
            this.propTxMode = 0;
        }
        switch (this.propTxMode) {
            case 0: {
                break;
            }
            case 1: {
                this.database.txManager = new TransactionManagerMV2PL(this.database);
                break;
            }
            case 2: {
                this.database.txManager = new TransactionManagerMVCC(this.database);
            }
        }
        String string5 = this.database.databaseProperties.getStringProperty("hsqldb.tx_level");
        this.database.defaultIsolationLevel = "SERIALIZABLE".equalsIgnoreCase(string5) ? 8 : 2;
        this.database.defaultDeadlockRollback = this.database.databaseProperties.isPropertyTrue("hsqldb.tx_deadlock_rollback");
        this.database.sqlEnforceNames = this.database.databaseProperties.isPropertyTrue("sql.enforce_names");
        this.database.sqlEnforceRefs = this.database.databaseProperties.isPropertyTrue("sql.enforce_refs");
        this.database.sqlEnforceSize = this.database.databaseProperties.isPropertyTrue("sql.enforce_size");
        this.database.sqlEnforceTypes = this.database.databaseProperties.isPropertyTrue("sql.enforce_types");
        this.database.sqlEnforceTDCD = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_delete");
        this.database.sqlEnforceTDCU = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_update");
        this.database.sqlTranslateTTI = this.database.databaseProperties.isPropertyTrue("jdbc.translate_tti_types");
        this.database.sqlConcatNulls = this.database.databaseProperties.isPropertyTrue("sql.concat_nulls");
        this.database.sqlUniqueNulls = this.database.databaseProperties.isPropertyTrue("sql.unique_nulls");
        this.database.sqlConvertTruncate = this.database.databaseProperties.isPropertyTrue("sql.convert_trunc");
        this.database.sqlDoubleNaN = this.database.databaseProperties.isPropertyTrue("sql.double_nan");
        this.database.sqlLongvarIsLob = this.database.databaseProperties.isPropertyTrue("sql.longvar_is_lob");
        this.database.sqlSyntaxMss = this.database.databaseProperties.isPropertyTrue("sql.syntax_mss");
        this.database.sqlSyntaxMys = this.database.databaseProperties.isPropertyTrue("sql.syntax_mys");
        this.database.sqlSyntaxOra = this.database.databaseProperties.isPropertyTrue("sql.syntax_ora");
        this.database.sqlSyntaxPgs = this.database.databaseProperties.isPropertyTrue("sql.syntax_pgs");
        if (this.database.databaseProperties.isPropertyTrue("sql.compare_in_locale")) {
            this.database.collation.setCollationAsLocale();
        }
        this.propEventLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.applog");
        this.propSqlLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.sqllog");
        this.propFilesReadOnly = this.database.databaseProperties.isPropertyTrue("files_readonly");
        this.propDatabaseReadOnly = this.database.databaseProperties.isPropertyTrue("readonly");
        this.propIncrementBackup = this.database.databaseProperties.isPropertyTrue("hsqldb.inc_backup");
        this.propNioDataFile = this.database.databaseProperties.isPropertyTrue("hsqldb.nio_data_file");
        this.propNioMaxSize = (long)(this.database.databaseProperties.getIntegerProperty("hsqldb.nio_max_size") * 1024) * 1024L;
        this.propCacheMaxRows = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_rows");
        this.propCacheMaxSize = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_size") * 1024;
        this.setLobFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.lob_file_scale"));
        this.setCacheFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.cache_file_scale"));
        this.propCacheDefragLimit = this.database.databaseProperties.getIntegerProperty("hsqldb.defrag_limit");
        this.propMaxFreeBlocks = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_free_count_scale");
        this.propMaxFreeBlocks = 1 << this.propMaxFreeBlocks;
        this.propTextAllowFullPath = this.database.databaseProperties.isPropertyTrue("textdb.allow_full_path");
        this.propWriteDelay = this.database.databaseProperties.getIntegerProperty("hsqldb.write_delay_millis");
        if (!this.database.databaseProperties.isPropertyTrue("hsqldb.write_delay")) {
            this.propWriteDelay = 0;
        }
        this.propLogSize = this.database.databaseProperties.getIntegerProperty("hsqldb.log_size");
        this.propLogData = this.database.databaseProperties.isPropertyTrue("hsqldb.log_data");
        this.propGC = this.database.databaseProperties.getIntegerProperty("runtime.gc_interval");
        this.propRefIntegrity = this.database.databaseProperties.isPropertyTrue("sql.ref_integrity");
    }

    public boolean closePersistence(int n) {
        if (this.log == null) {
            return true;
        }
        this.database.lobManager.deleteUnusedLobs();
        try {
            switch (n) {
                case 1: {
                    this.log.shutdown();
                    break;
                }
                case 2: {
                    this.log.close(false);
                    break;
                }
                case 3: 
                case 4: {
                    this.log.close(true);
                }
            }
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("error closing log", throwable);
            this.log = null;
            return false;
        }
        this.database.logger.logInfoEvent("Database closed");
        this.log = null;
        this.appLog.close();
        this.logsStatements = false;
        this.loggingEnabled = false;
        return true;
    }

    String newUniqueName() {
        String string = StringUtil.toPaddedString(Long.toHexString(System.currentTimeMillis()), 16, '0', false);
        string = "HSQLDB" + string.substring(6).toUpperCase(Locale.ENGLISH);
        return string;
    }

    public boolean isLogged() {
        return DatabaseURL.isFileBasedDatabaseType(this.database.getType()) && !this.database.isFilesReadOnly();
    }

    private void getEventLogger() {
        if (this.fwLogger != null) {
            return;
        }
        String string = this.database.getUniqueName();
        if (string == null) {
            return;
        }
        this.fwLogger = FrameworkLogger.getLog("ENGINE", "hsqldb.db." + this.database.getUniqueName());
    }

    public void setEventLogLevel(int n, boolean bl) {
        if (n < 0 || n > 3) {
            throw Error.error(5556);
        }
        if (bl) {
            this.propSqlLogLevel = n;
            this.sqlLog.setLevel(n);
        } else {
            this.propEventLogLevel = n;
            this.appLog.setLevel(n);
        }
    }

    public void logSevereEvent(String string, Throwable throwable) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.severe(string, throwable);
        }
        if (this.appLog != null) {
            if (throwable == null) {
                this.appLog.logContext(1, string);
            } else {
                this.appLog.logContext(throwable, string, 1);
            }
        }
    }

    public void logWarningEvent(String string, Throwable throwable) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.warning(string, throwable);
        }
        this.appLog.logContext(throwable, string, 1);
    }

    public void logInfoEvent(String string) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.info(string);
        }
        this.appLog.logContext(2, string);
    }

    public void logDetailEvent(String string) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.finest(string);
        }
        if (this.appLog != null) {
            this.appLog.logContext(3, string);
        }
    }

    public void logStatementEvent(Session session, Statement statement, Object[] objectArray, int n) {
        this.getEventLogger();
        if (this.sqlLogger != null) {
            this.sqlLogger.finest(statement.getSQL());
        }
        if (this.sqlLog != null && n <= this.propSqlLogLevel) {
            String string = Long.toString(session.getId());
            String string2 = statement.getSQL();
            String string3 = "";
            if (string2.length() > 100) {
                string2.substring(0, 100);
            }
            if (n == 3 && objectArray != null && objectArray.length > 0) {
                string3 = RowType.convertToSQLString(objectArray, statement.getParametersMetaData().getParameterTypes(), 32);
            }
            this.sqlLog.logContext(3, string, string2, string3);
        }
    }

    public int getSqlEventLogLevel() {
        return this.propSqlLogLevel;
    }

    private DataFileCache getCache() {
        if (this.log == null) {
            return null;
        }
        return this.log.getCache();
    }

    private boolean hasCache() {
        if (this.log == null) {
            return false;
        }
        return this.log.hasCache();
    }

    public synchronized void writeStartSession(Session session) {
        if (this.loggingEnabled) {
            this.log.writeOtherStatement(session, session.getUser().getConnectUserSQL());
        }
    }

    public synchronized void writeOtherStatement(Session session, String string) {
        if (this.loggingEnabled) {
            this.log.writeOtherStatement(session, string);
        }
    }

    public synchronized void writeInsertStatement(Session session, Row row, Table table) {
        if (this.loggingEnabled) {
            this.log.writeInsertStatement(session, row, table);
        }
    }

    public synchronized void writeDeleteStatement(Session session, Table table, Object[] objectArray) {
        if (this.loggingEnabled) {
            this.log.writeDeleteStatement(session, table, objectArray);
        }
    }

    public synchronized void writeSequenceStatement(Session session, NumberSequence numberSequence) {
        if (this.loggingEnabled) {
            this.log.writeSequenceStatement(session, numberSequence);
        }
    }

    public synchronized void writeCommitStatement(Session session) {
        if (this.loggingEnabled) {
            this.log.writeCommitStatement(session);
        }
    }

    public synchronized void writeRollbackStatement(Session session) {
        if (this.loggingEnabled) {
            this.log.writeOtherStatement(session, "ROLLBACK");
        }
    }

    public synchronized void checkpoint(boolean bl) {
        if (this.logsStatements) {
            this.database.logger.logInfoEvent("Checkpoint start");
            this.database.lobManager.synch();
            this.log.checkpoint(bl);
            this.database.sessionManager.resetLoggedSchemas();
            this.database.logger.logInfoEvent("Checkpoint end");
        } else if (!this.isFileDatabase()) {
            this.database.lobManager.deleteUnusedLobs();
        }
        this.checkpointRequired = false;
        this.checkpointDue = false;
    }

    public synchronized void setLogSize(int n) {
        this.propLogSize = n;
        if (this.log != null) {
            this.log.setLogSize(this.propLogSize);
        }
    }

    public synchronized void setLogData(boolean bl) {
        this.propLogData = bl;
        this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        this.loggingEnabled &= this.logsStatements;
    }

    public synchronized void setScriptType(int n) {
        if (n == this.propScriptFormat) {
            return;
        }
        this.propScriptFormat = n;
        this.checkpointRequired = true;
    }

    public synchronized void setWriteDelay(int n) {
        this.propWriteDelay = n;
        if (this.log != null) {
            this.syncFile = n == 0;
            this.log.setWriteDelay(n);
        }
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public int getWriteDelay() {
        return this.propWriteDelay;
    }

    public int getLogSize() {
        return this.propLogSize;
    }

    public int getLobBlockSize() {
        return this.propLobBlockSize;
    }

    public synchronized void setIncrementBackup(boolean bl) {
        if (bl == this.propIncrementBackup) {
            return;
        }
        if (this.log != null) {
            this.log.setIncrementBackup(bl);
            if (this.log.hasCache()) {
                this.checkpointRequired = true;
            }
        }
        this.propIncrementBackup = bl;
    }

    public void setCacheMaxRows(int n) {
        this.propCacheMaxRows = n;
    }

    public int getCacheRowsDefault() {
        return this.propCacheMaxRows;
    }

    public void setCacheSize(int n) {
        this.propCacheMaxSize = n * 1024;
    }

    public int getCacheSize() {
        return this.propCacheMaxSize;
    }

    public void setCacheFileScale(int n) {
        if (this.propCacheFileScale == n) {
            return;
        }
        Logger.checkPower(n, 8);
        if (n < 8 && n != 1) {
            throw Error.error(5556);
        }
        if (this.hasCache()) {
            throw Error.error(469);
        }
        this.propCacheFileScale = n;
    }

    public void setCacheFileScaleNoCheck(int n) {
        Logger.checkPower(n, 8);
        if (n < 8 && n != 1) {
            throw Error.error(5556);
        }
        this.propCacheFileScale = n;
    }

    public int getCacheFileScale() {
        return this.propCacheFileScale;
    }

    public void setLobFileScale(int n) {
        if (this.propLobBlockSize == n * 1024) {
            return;
        }
        Logger.checkPower(n, 6);
        if (this.database.lobManager.getLobCount() > 0) {
            throw Error.error(469);
        }
        this.propLobBlockSize = n * 1024;
        this.database.lobManager.close();
        this.database.lobManager.open();
    }

    public void setLobFileScaleNoCheck(int n) {
        Logger.checkPower(n, 6);
        this.propLobBlockSize = n * 1024;
    }

    public int getLobFileScale() {
        return this.propLobBlockSize / 1024;
    }

    public void setDefagLimit(int n) {
        this.propCacheDefragLimit = n;
    }

    public int getDefragLimit() {
        return this.propCacheDefragLimit;
    }

    public void setDefaultTextTableProperties(String string, HsqlProperties hsqlProperties) {
        hsqlProperties.setProperty("check_props", true);
        this.database.getProperties().setURLProperties(hsqlProperties);
        this.propTextSourceDefault = string;
    }

    public void setNioDataFile(boolean bl) {
        this.propNioDataFile = bl;
    }

    public void setNioMaxSize(int n) {
        Logger.checkPower(n, 12);
        if (n < 8) {
            throw Error.error(5556);
        }
        this.propNioMaxSize = (long)n * 1024L * 1024L;
    }

    public FileAccess getFileAccess() {
        return this.fileAccess;
    }

    public boolean isStoredFileAccess() {
        return this.isStoredFileAccess;
    }

    public boolean isFileDatabase() {
        return this.propIsFileDatabase;
    }

    public String getTempDirectoryPath() {
        return this.tempDirectoryPath;
    }

    static void checkPower(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if ((n & 1) != 0) {
                if ((n | 1) != 1) {
                    throw Error.error(5556);
                }
                return;
            }
            n >>= 1;
        }
        throw Error.error(5556);
    }

    public DataFileCache openTextFilePersistence(Table table, String string, boolean bl, boolean bl2) {
        return this.log.openTextCache(table, string, bl, bl2);
    }

    public void closeTextCache(Table table) {
        this.log.closeTextCache(table);
    }

    public synchronized void setCheckpointRequired() {
        this.checkpointRequired = true;
    }

    public synchronized boolean needsCheckpointReset() {
        if (this.checkpointRequired && !this.checkpointDue && !this.checkpointDisabled) {
            this.checkpointDue = true;
            this.checkpointRequired = false;
            return true;
        }
        return false;
    }

    public boolean hasLockFile() {
        return this.lockFile != null;
    }

    public void acquireLock(String string) {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = LockFile.newLockFileLock(string);
    }

    public void releaseLock() {
        try {
            if (this.lockFile != null) {
                this.lockFile.tryRelease();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lockFile = null;
    }

    public PersistentStore newStore(Session session, PersistentStoreCollection persistentStoreCollection, TableBase tableBase) {
        switch (tableBase.getTableType()) {
            case 5: {
                DataFileCache dataFileCache = this.getCache();
                if (dataFileCache == null) break;
                return new RowStoreAVLDisk(persistentStoreCollection, dataFileCache, (Table)tableBase);
            }
            case 4: 
            case 11: 
            case 12: {
                return new RowStoreAVLMemory(persistentStoreCollection, (Table)tableBase);
            }
            case 7: {
                return new RowStoreAVLDiskData(persistentStoreCollection, (Table)tableBase);
            }
            case 1: {
                return new RowStoreAVLHybridExtended(session, persistentStoreCollection, tableBase, false);
            }
            case 3: {
                return new RowStoreAVLHybridExtended(session, persistentStoreCollection, tableBase, true);
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                if (session == null) {
                    return null;
                }
                return new RowStoreAVLHybrid(session, persistentStoreCollection, tableBase, true);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(HsqlNameManager.HsqlName hsqlName, long l, TableBase tableBase, int[] nArray, boolean[] blArray, boolean[] blArray2, Type[] typeArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        switch (tableBase.getTableType()) {
            case 1: 
            case 4: 
            case 12: {
                return new IndexAVLMemory(hsqlName, l, tableBase, nArray, blArray, blArray2, typeArray, bl, bl2, bl3, bl4);
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return new IndexAVL(hsqlName, l, tableBase, nArray, blArray, blArray2, typeArray, bl, bl2, bl3, bl4);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(Table table, Index index, int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        Object[] objectArray = new Type[nArray.length];
        ArrayUtil.projectRow(table.getColumnTypes(), nArray, objectArray);
        switch (table.getTableType()) {
            case 4: {
                return new IndexAVLMemory(index.getName(), index.getPersistenceId(), table, nArray, blArray, blArray, (Type[])objectArray, false, false, false, false);
            }
            case 5: 
            case 7: {
                return new IndexAVL(index.getName(), index.getPersistenceId(), table, nArray, blArray, blArray, (Type[])objectArray, false, false, false, false);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public String getValueStringForProperty(String string) {
        String string2 = "";
        if ("hsqldb.tx".equals(string)) {
            switch (this.database.txManager.getTransactionControl()) {
                case 2: {
                    string2 = "MVCC".toLowerCase();
                    break;
                }
                case 1: {
                    string2 = "MVLOCKS".toLowerCase();
                    break;
                }
                case 0: {
                    string2 = "LOCKS".toLowerCase();
                }
            }
            return string2;
        }
        if ("hsqldb.tx_level".equals(string)) {
            switch (this.database.defaultIsolationLevel) {
                case 2: {
                    string2 = new StringBuffer("READ").append(' ').append("COMMITTED").toString().toLowerCase();
                    break;
                }
                case 8: {
                    string2 = "SERIALIZABLE".toLowerCase();
                }
            }
            return string2;
        }
        if ("hsqldb.applog".equals(string)) {
            return String.valueOf(this.appLog.getLevel());
        }
        if ("hsqldb.lob_file_scale".equals(string)) {
            return String.valueOf(this.propLobBlockSize);
        }
        if ("hsqldb.cache_file_scale".equals(string)) {
            return String.valueOf(this.propCacheFileScale);
        }
        if ("hsqldb.cache_free_count_scale".equals(string)) {
            return String.valueOf(this.propMaxFreeBlocks);
        }
        if ("hsqldb.cache_rows".equals(string)) {
            return String.valueOf(this.propCacheMaxRows);
        }
        if ("hsqldb.cache_size".equals(string)) {
            String.valueOf(this.propCacheMaxSize);
        }
        if ("hsqldb.default_table_type".equals(string)) {
            return this.database.schemaManager.getDefaultTableType() == 5 ? "cached" : "memory";
        }
        if ("hsqldb.defrag_limit".equals(string)) {
            return String.valueOf(this.propCacheDefragLimit);
        }
        if ("files_readonly".equals(string)) {
            return this.database.databaseProperties.getPropertyString("files_readonly");
        }
        if ("hsqldb.lock_file".equals(string)) {
            return this.database.databaseProperties.getPropertyString("hsqldb.lock_file");
        }
        if ("hsqldb.log_data".equals(string)) {
            return String.valueOf(this.propLogData);
        }
        if ("hsqldb.log_size".equals(string)) {
            return String.valueOf(this.propLogSize);
        }
        if ("hsqldb.nio_data_file".equals(string)) {
            return String.valueOf(this.propNioDataFile);
        }
        if ("hsqldb.nio_max_size".equals(string)) {
            return String.valueOf(this.propNioMaxSize);
        }
        if ("hsqldb.script_format".equals(string)) {
            return ScriptWriterBase.LIST_SCRIPT_FORMATS[0].toLowerCase();
        }
        if ("hsqldb.temp_directory".equals(string)) {
            return null;
        }
        if ("hsqldb.result_max_memory_rows".equals(string)) {
            return String.valueOf(this.database.getResultMaxMemoryRows());
        }
        if ("hsqldb.write_delay".equals(string)) {
            return String.valueOf(this.propWriteDelay != 0);
        }
        if ("hsqldb.write_delay_millis".equals(string)) {
            return String.valueOf(this.propWriteDelay);
        }
        if ("sql.ref_integrity".equals(string)) {
            return this.database.isReferentialIntegrity() ? "true" : "false";
        }
        if ("sql.compare_in_locale".equals(string)) {
            return null;
        }
        if ("sql.enforce_size".equals(string)) {
            return String.valueOf(this.database.sqlEnforceSize);
        }
        if ("sql.enforce_refs".equals(string)) {
            return String.valueOf(this.database.sqlEnforceRefs);
        }
        if ("sql.enforce_names".equals(string)) {
            return String.valueOf(this.database.sqlEnforceNames);
        }
        if ("sql.enforce_types".equals(string)) {
            return String.valueOf(this.database.sqlEnforceTypes);
        }
        if ("jdbc.translate_tti_types".equals(string)) {
            return String.valueOf(this.database.sqlTranslateTTI);
        }
        return null;
    }

    public String[] getPropertiesSQL() {
        int n;
        boolean bl;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET DATABASE ").append("UNIQUE").append(' ');
        stringBuffer.append("NAME").append(' ').append(this.database.getUniqueName());
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("GC").append(' ');
        stringBuffer.append(this.propGC);
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("DEFAULT").append(' ');
        stringBuffer.append("RESULT").append(' ').append("MEMORY");
        stringBuffer.append(' ').append("ROWS").append(' ');
        stringBuffer.append(this.database.getResultMaxMemoryRows());
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("EVENT").append(' ');
        stringBuffer.append("LOG").append(' ').append("LEVEL");
        stringBuffer.append(' ').append(this.propEventLogLevel);
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("NAMES").append(' ');
        stringBuffer.append(this.database.sqlEnforceNames ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("REFERENCES").append(' ');
        stringBuffer.append(this.database.sqlEnforceRefs ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("SIZE").append(' ');
        stringBuffer.append(this.database.sqlEnforceSize ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("TYPES").append(' ');
        stringBuffer.append(this.database.sqlEnforceTypes ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("TDC").append(' ');
        stringBuffer.append("DELETE").append(' ');
        stringBuffer.append(this.database.sqlEnforceTDCD ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("TDC").append(' ');
        stringBuffer.append("UPDATE").append(' ');
        stringBuffer.append(this.database.sqlEnforceTDCU ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("TRANSLATE").append(' ').append("TTI");
        stringBuffer.append(' ').append("TYPES").append(' ');
        stringBuffer.append(this.database.sqlTranslateTTI ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("CONCAT").append(' ');
        stringBuffer.append("NULLS").append(' ');
        stringBuffer.append(this.database.sqlConcatNulls ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("UNIQUE").append(' ');
        stringBuffer.append("NULLS").append(' ');
        stringBuffer.append(this.database.sqlUniqueNulls ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("CONVERT").append(' ');
        stringBuffer.append("TRUNCATE").append(' ');
        stringBuffer.append(this.database.sqlConvertTruncate ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("DOUBLE").append(' ');
        stringBuffer.append("NAN").append(' ');
        stringBuffer.append(this.database.sqlDoubleNaN ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
        stringBuffer.append("LONGVAR").append(' ');
        stringBuffer.append("IS").append(' ');
        stringBuffer.append("LOB").append(' ');
        stringBuffer.append(this.database.sqlLongvarIsLob ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        if (this.database.sqlSyntaxMss) {
            stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
            stringBuffer.append("SYNTAX").append(' ');
            stringBuffer.append("MSS").append(' ');
            stringBuffer.append(this.database.sqlSyntaxMss ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        if (this.database.sqlSyntaxOra) {
            stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
            stringBuffer.append("SYNTAX").append(' ');
            stringBuffer.append("ORA").append(' ');
            stringBuffer.append(this.database.sqlSyntaxOra ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        if (this.database.sqlSyntaxMys) {
            stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
            stringBuffer.append("SYNTAX").append(' ');
            stringBuffer.append("MYS").append(' ');
            stringBuffer.append(this.database.sqlSyntaxMys ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        if (this.database.sqlSyntaxPgs) {
            stringBuffer.append("SET DATABASE ").append("SQL").append(' ');
            stringBuffer.append("SYNTAX").append(' ');
            stringBuffer.append("PGS").append(' ');
            stringBuffer.append(this.database.sqlSyntaxPgs ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        stringBuffer.append("SET DATABASE ").append("TRANSACTION");
        stringBuffer.append(' ').append("CONTROL").append(' ');
        switch (this.database.txManager.getTransactionControl()) {
            case 2: {
                stringBuffer.append("MVCC");
                break;
            }
            case 1: {
                stringBuffer.append("MVLOCKS");
                break;
            }
            case 0: {
                stringBuffer.append("LOCKS");
            }
        }
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("DEFAULT").append(' ');
        stringBuffer.append("ISOLATION").append(' ').append("LEVEL");
        stringBuffer.append(' ');
        switch (this.database.defaultIsolationLevel) {
            case 2: {
                stringBuffer.append("READ").append(' ').append("COMMITTED");
                break;
            }
            case 8: {
                stringBuffer.append("SERIALIZABLE");
            }
        }
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("TRANSACTION");
        stringBuffer.append(' ').append("ROLLBACK").append(' ');
        stringBuffer.append("ON").append(' ');
        stringBuffer.append("DEADLOCK").append(' ');
        stringBuffer.append(this.database.defaultDeadlockRollback ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET DATABASE ").append("TEXT").append(' ');
        stringBuffer.append("TABLE").append(' ').append("DEFAULTS");
        stringBuffer.append(' ').append('\'');
        stringBuffer.append(this.propTextSourceDefault).append('\'');
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        if (this.database.schemaManager.getDefaultTableType() == 5) {
            hsqlArrayList.add("SET DATABASE DEFAULT TABLE TYPE CACHED");
        }
        boolean bl2 = bl = (n = this.propWriteDelay) > 0 && n < 1000;
        if (bl) {
            if (n < 20) {
                n = 20;
            }
        } else {
            n /= 1000;
        }
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("WRITE").append(' ');
        stringBuffer.append("DELAY").append(' ').append(n);
        if (bl) {
            stringBuffer.append(' ').append("MILLIS");
        }
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("BACKUP");
        stringBuffer.append(' ').append("INCREMENT").append(' ');
        stringBuffer.append(this.propIncrementBackup ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("CACHE");
        stringBuffer.append(' ').append("SIZE").append(' ');
        stringBuffer.append(this.propCacheMaxSize / 1024);
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("CACHE");
        stringBuffer.append(' ').append("ROWS").append(' ');
        stringBuffer.append(this.propCacheMaxRows);
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("SCALE");
        stringBuffer.append(' ').append(this.propCacheFileScale);
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("LOB").append(' ').append("SCALE");
        stringBuffer.append(' ').append(this.getLobFileScale());
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("DEFRAG");
        stringBuffer.append(' ').append(this.propCacheDefragLimit);
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("NIO");
        stringBuffer.append(' ').append(this.propNioDataFile ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("NIO").append(' ').append("SIZE");
        stringBuffer.append(' ').append(this.propNioMaxSize / 0x100000L);
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("LOG").append(' ');
        stringBuffer.append(this.propLogData ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("SET FILES ").append("LOG").append(' ');
        stringBuffer.append("SIZE").append(' ').append(this.propLogSize);
        hsqlArrayList.add(stringBuffer.toString());
        stringBuffer.setLength(0);
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public synchronized void backup(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        String string2 = this.database.getPath();
        if (runtimeFileDelim == null) {
            runtimeFileDelim = new Character(System.getProperty("file.separator").charAt(0));
        }
        String string3 = new File(string2).getName();
        if (string == null || string.length() < 1) {
            throw Error.error(3414, "0-length destination path");
        }
        char c = string.charAt(string.length() - 1);
        boolean bl5 = c == '/' || c == runtimeFileDelim.charValue();
        String string4 = bl3 ? ".tar.gz" : ".tar";
        File file = bl5 ? new File(string.substring(0, string.length() - 1), string3 + '-' + backupFileFormat.format(new Date()) + string4) : new File(string);
        boolean bl6 = bl4 = file.getName().endsWith(".tar.gz") || file.getName().endsWith(".tgz");
        if (!bl4 && !file.getName().endsWith(".tar")) {
            throw Error.error(null, 462, 0, new String[]{file.getName(), ".tar, .tar.gz, .tgz"});
        }
        if (bl3 != bl4) {
            throw Error.error(null, 463, 0, new Object[]{new Boolean(bl3), file.getName()});
        }
        this.log.checkpointClose();
        try {
            this.database.logger.logInfoEvent("Initiating backup of instance '" + string3 + "'");
            DbBackup dbBackup = new DbBackup(file, string2);
            dbBackup.setAbortUponModify(false);
            dbBackup.write();
            this.database.logger.logInfoEvent("Successfully backed up instance '" + string3 + "' to '" + string + "'");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Error.error(6609, illegalArgumentException.toString());
        }
        catch (IOException iOException) {
            throw Error.error(452, iOException.toString());
        }
        catch (TarMalformatException tarMalformatException) {
            throw Error.error(452, tarMalformatException.toString());
        }
        finally {
            this.log.checkpointReopen();
        }
    }
}

