package it.unibo.tw.hibernate;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Restrictions;

public class HibernateTest {

	  public static void main(String[] args){
		  
		  Session session = new Configuration().configure().buildSessionFactory().openSession();
		  Transaction tx = null;

		  try {		  
			  tx = session.beginTransaction();	
			    
			  // Student
			  
			  Student student = new Student();
			  student.setId(1);
			  student.setFirstName("Marco");
			  student.setLastName("Rossi");
			  Calendar c = Calendar.getInstance();
			  c.set(1984, 1, 24);
			  student.setBirthDate(c.getTime());
			  session.persist(student);
			  
			  student = new Student();
			  student.setId(2);
			  student.setFirstName("Giovanni");
			  student.setLastName("Gialli");
			  c = Calendar.getInstance();
			  c.set(1983, 4, 13);
			  student.setBirthDate(c.getTime());
			  session.persist(student);		
			  
			  tx.commit();


			  // richiedo l'elenco degli studenti che hanno cognome "Gialli"
			  // versione SQL
			  System.out.println();
			  System.out.println("query students: sql/hql");
			  
			  // query HQL: il nome della tabella  ottenuto tramite il mapping  
			  //			presente nel file XML relativo alla classe Student
			  Query query = session.createQuery("from "+Student.class.getSimpleName()+" where lastName = ?");
			 
			  // variante SQL: classica query in cui sis pecifica il nome della tabella
			  //Query query = session.createSQLQuery("select * from students where lastName = ?").addEntity(Student.class);
			  
			  query.setString(0, "Gialli");
			  List<Student> students = query.list();
			  System.out.println("students.size() "+ students.size());
			  Iterator<Student> itStudent = students.iterator();
			  while(itStudent.hasNext()){
				  Student studentResult = itStudent.next();
				  System.out.println(studentResult.getFirstName()+" "+ studentResult.getLastName()+" "+studentResult.getBirthDate());
			  }
			  
			  // versione Criteria: soluzione completamente object-oriented
			  System.out.println();
			  System.out.println("query students: criteria");
			  Criteria criteria = session.createCriteria(Student.class);
			  criteria.add(Restrictions.eq("lastName", "Gialli"));
			  students = criteria.list();
			  System.out.println("students.size() "+ students.size());
			  for(Student studentResult : students){
				  System.out.println(studentResult.getFirstName()+" "+ studentResult.getLastName()+" "+studentResult.getBirthDate());
			  }
				
				
				
				// Courses
				
			  	tx = session.beginTransaction();
				
				Course course = new Course();
				course.setId(1);
				course.setName("Sistemi Informativi");
				session.persist(course);
				
				course = new Course();
				course.setId(2);
				course.setName("Reti di Calcolatori");
				session.persist(course);
				
				tx.commit();
				
				
				System.out.println();
				System.out.println("query corso con id = 1 (versione hql)");
				query = session.createQuery("from "+Course.class.getSimpleName()+" where id = ?");
				query.setInteger(0, 1);
				Course courseResult = (Course)query.uniqueResult();
				System.out.println("query Course hql: "+courseResult.getId()+" "+ courseResult.getName());
				
				System.out.println();
				System.out.println("query corso con id = 1 (versione criteria)");
				criteria = session.createCriteria(Course.class);
				criteria.add(Restrictions.idEq(1));
				courseResult = (Course)criteria.uniqueResult();
				System.out.println("query Course criteria: "+courseResult.getId()+" "+ courseResult.getName());
				

				// StudentCoursesMapping (mapping in JAVA! 3 java bean 3 tabelle)

			  	tx = session.beginTransaction();
				
				CourseStudentMapping mapping = new CourseStudentMapping();
				mapping.setIdCourse(1);
				mapping.setIdStudent(1);
				session.persist(mapping);
				
				mapping = new CourseStudentMapping();
				mapping.setIdCourse(2);
				mapping.setIdStudent(1);
				session.persist(mapping);
				
				mapping = new CourseStudentMapping();
				mapping.setIdCourse(1);
				mapping.setIdStudent(2);
				session.persist(mapping);

				tx.commit();
				
				
							
				
				System.out.println();
				System.out.println("query studenti del corso con id = 1 (versione hql)");
				query = session.createQuery("from "+CourseStudentMapping.class.getSimpleName()+" where idCourse = ?");
				query.setInteger(0, 1);
				List<CourseStudentMapping> mappingResults = query.list();
				System.out.println("mappingResults.size() "+ mappingResults.size());
				Iterator<CourseStudentMapping> itMapping = mappingResults.iterator();
				while(itMapping.hasNext()){
					CourseStudentMapping mappingResult = itMapping.next();
					query = session.createQuery("from "+Student.class.getSimpleName()+" where id = ?");
					query.setInteger(0, mappingResult.getIdStudent());
					Student studentResult = (Student)query.uniqueResult();
					System.out.println(studentResult.getFirstName()+" "+ studentResult.getLastName()+" "+studentResult.getBirthDate());
				}				
				
				System.out.println();
				System.out.println("query studenti del corso con id = 1 (versione criteria)");
				criteria = session.createCriteria(CourseStudentMapping.class);
				criteria.add(Restrictions.eq("idCourse", 1));
				mappingResults = criteria.list();
				System.out.println("mappingResults.size() "+ mappingResults.size());
				itMapping = mappingResults.iterator();
				while(itMapping.hasNext()){
					CourseStudentMapping mappingR = itMapping.next();
					criteria = session.createCriteria(Student.class);
					criteria.add(Restrictions.idEq(mappingR.getIdStudent()));
					Student studentResult = (Student)criteria.uniqueResult();
					System.out.println(studentResult.getFirstName()+" "+ studentResult.getLastName()+" "+studentResult.getBirthDate());
				}
				
				
				System.out.println();
				System.out.println("query corsi dello studente con id = 2 (versione hql)");
				query = session.createQuery("from "+CourseStudentMapping.class.getSimpleName()+" where idStudent = ?");
				query.setInteger(0, 2);
				mappingResults = query.list();
				System.out.println("mappingResults.size() "+ mappingResults.size());
				itMapping = mappingResults.iterator();
				while(itMapping.hasNext()){
					CourseStudentMapping mappingResult = itMapping.next();
					query = session.createQuery("from "+Course.class.getSimpleName()+" where id = ?");
					query.setInteger(0, mappingResult.getIdCourse());
					courseResult = (Course)query.uniqueResult();
					System.out.println(courseResult.getName());
				}	

				System.out.println();
				System.out.println("query corsi dello studente con id = 2 (versione criteria)");
				criteria = session.createCriteria(CourseStudentMapping.class);
				criteria.add(Restrictions.eq("idStudent", 2));
				mappingResults = criteria.list();
				System.out.println("mappingResults.size() "+ mappingResults.size());
				itMapping = mappingResults.iterator();
				while(itMapping.hasNext()){
					CourseStudentMapping mappingR = itMapping.next();
					criteria = session.createCriteria(Course.class);
					criteria.add(Restrictions.idEq(mappingR.getIdCourse()));
					courseResult = (Course)criteria.uniqueResult();
					System.out.println(courseResult.getName());
				}
				
				
				
				// Mapping in hibernate AUTOMATICO! (2 java bean , 3 tabelle)
				// decommentarla per farla girare e commentare la parte precedente di mapping java
				// ricordarsi anche di configurare il file hibernate.cfg.xml in modo opportuno riferendo i nuovo xml 
				// nel package it.unibo.tw.hibernate.bis
				
				/*  
				  tx = session.beginTransaction();	
				
				  Student s1 = new Student();
				  s1.setId(3);
				  s1.setFirstName("pippo");
				  s1.setLastName("paperino");
				  Calendar ca = Calendar.getInstance();
				  ca.set(1998, 2, 28);
				  s1.setBirthDate(ca.getTime());
				  session.persist(s1);
				
				  Course c1 = new Course();
				  c1.setId(3);
				  c1.setName("corsopippo");
				  session.persist(c1);
				  
				  Set<Course> corsi = new HashSet<Course>();
				  corsi.add(c1);
				  s1.setCourses(corsi);
				  session.saveOrUpdate(s1);
				  
				  Set<Student> studenti = new HashSet<Student>();
				  studenti.add(s1);
				  c1.setStudents(studenti);
				  session.saveOrUpdate(c1);
				  
				  tx.commit();
				  
				  
				  query = session.createQuery("from "+Student.class.getSimpleName()+" where id=?");
				  query.setInteger(0, 3);
				  List<Student> lista = query.list();
				  Set<Course> corsiPippo = lista.get(0).getCourses();
				  System.out.println("corsi sostenuti da pippo: \n\t");
				  for(Course corso : corsiPippo)
					  System.out.println("corso: "+corso.getName()+"\n");
				
				*/
		  }
		  catch (Exception e1) {
		      if (tx != null){
		    	  try{
		    		  tx.rollback();
		    	  }
		    	  catch(Exception e2){
		    		  e2.printStackTrace();
		    	  }
		      }
		      e1.printStackTrace();
		  }
		  finally {
			  session.close();
		  }
		  
	  }
}
