package it.unibo.tw.es2.servlets;

import it.unibo.tw.es2.beans.DescrizioneMacchina;
import it.unibo.tw.es2.persistence.Db2MacchinaDAO;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.MarshallException;

import com.google.gson.Gson;

public class CercaMacchine extends HttpServlet {
	
	private static final long serialVersionUID = 1L;

	// MODIFICA GSON
			private Gson gson;
	// FINE MODIFICA GSON
	
	@Override
	public void init() throws ServletException {
		
//      persistenza con DB2		
		
		Db2MacchinaDAO persist = new Db2MacchinaDAO();
		persist.create("aa111aa",new DescrizioneMacchina("m1","c1"));
		persist.create("bb222bb",new DescrizioneMacchina("m2","c2"));
		persist.create("cc333bb",new DescrizioneMacchina("m3","c3"));
		persist.create("dd444dd",new DescrizioneMacchina("m4","c4"));
		persist.create("ee555ee",new DescrizioneMacchina("m5","c5"));
		
//      persistenza con HashMap al posto di DB2
		
//		Hashtable<String,DescrizioneMacchina> db = new Hashtable<String,DescrizioneMacchina>();
//		db.put("aa111aa",new DescrizioneMacchina("m1","c1"));
//		db.put("bb222bb",new DescrizioneMacchina("m2","c2"));
//		db.put("cc333bb",new DescrizioneMacchina("m3","c3"));
//		db.put("dd444dd",new DescrizioneMacchina("m4","c4"));
//		db.put("ee555ee",new DescrizioneMacchina("m5","c5"));
		
		this.getServletContext().setAttribute("db", persist);
		
		//MODIFICA GSON
		gson = new Gson();

//JSONSerializer serializer = new JSONSerializer();
//try {
//	// inizializza i tipi serializzatori forniti di default 
//	serializer.registerDefaultSerializers(); 
//} 
//catch (Exception e) {
//	System.out.println(e.getMessage());
//	e.printStackTrace();
//}
//this.getServletContext().setAttribute("serializer", serializer);
		this.getServletContext().setAttribute("serializer", gson);		
//FINE MODIFICA GSON
	}
	
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		
		String targa = req.getParameter("targa");
		if( targa != null ){
			
//			Hashtable<String,DescrizioneMacchina> db = (Hashtable<String,DescrizioneMacchina>)this.getServletContext().getAttribute("db");
//			DescrizioneMacchina macchina = db.get(targa);
			
			Db2MacchinaDAO persist = (Db2MacchinaDAO)this.getServletContext().getAttribute("db");
			DescrizioneMacchina macchina = persist.getMacchina(targa);
			
			if( macchina == null ){
				macchina = new DescrizioneMacchina("errore","errore");
			}
			// MODIFICA GSON
						gson = (Gson)this.getServletContext().getAttribute("serializer");
//						JSONSerializer serializer = (JSONSerializer)this.getServletContext().getAttribute("serializer");
//						try {
//							String output = serializer.toJSON(macchina);
//							resp.getOutputStream().print(output);
//						} 
//						catch (MarshallException e) {
//							e.printStackTrace();
//						}
		
						String output = gson.toJson(macchina);
						resp.getOutputStream().print(output);
						
						//FINE MODIFICA GSON
			
		}
		
	}
	
}
