/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import [Ljava.lang.Boolean;;
import [Ljava.lang.Double;;
import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.Long;;
import [Ljava.lang.Short;;
import [Ljava.lang.String;;
import java.lang.reflect.Array;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ArraySerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static final Class[] _serializableClasses = new Class[]{[I.class, [S.class, [J.class, [F.class, [D.class, [Z.class, Integer;.class, Short;.class, Long;.class, Float;.class, Double;.class, Boolean;.class, String;.class};
    private static final Class[] _JSONClasses = new Class[]{JSONArray.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        Class<?> cc = clazz.getComponentType();
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONArray.class) && clazz.isArray() && !cc.isPrimitive() || clazz == Object.class && jsonClazz == JSONArray.class;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        JSONArray jso = (JSONArray)o;
        Class<?> cc = clazz.getComponentType();
        ObjectMatch m = new ObjectMatch(-1);
        state.setSerialized(o, m);
        try {
            for (i = 0; i < jso.length(); ++i) {
                m.setMismatch(this.ser.tryUnmarshall(state, cc, jso.get(i)).max(m).getMismatch());
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage() + " not found in json object", e);
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        JSONArray jso = (JSONArray)o;
        Class cc = clazz.getComponentType();
        try {
            if (clazz == [I.class) {
                int[] arr = new int[jso.length()];
                state.setSerialized(o, arr);
                for (i = 0; i < jso.length(); ++i) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).intValue();
                }
                return arr;
            }
            if (clazz == [B.class) {
                byte[] arr = new byte[jso.length()];
                state.setSerialized(o, arr);
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).byteValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [S.class) {
                short[] arr = new short[jso.length()];
                state.setSerialized(o, arr);
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).shortValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [J.class) {
                long[] arr = new long[jso.length()];
                state.setSerialized(o, arr);
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).longValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [F.class) {
                float[] arr = new float[jso.length()];
                state.setSerialized(o, arr);
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).floatValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [D.class) {
                double[] arr = new double[jso.length()];
                state.setSerialized(o, arr);
                while (i < jso.length()) {
                    arr[i] = ((Number)this.ser.unmarshall(state, cc, jso.get(i))).doubleValue();
                    ++i;
                }
                return arr;
            }
            if (clazz == [C.class) {
                char[] arr = new char[jso.length()];
                while (i < jso.length()) {
                    arr[i] = ((String)this.ser.unmarshall(state, cc, jso.get(i))).charAt(0);
                    ++i;
                }
                return arr;
            }
            if (clazz == [Z.class) {
                boolean[] arr = new boolean[jso.length()];
                state.setSerialized(o, arr);
                while (i < jso.length()) {
                    arr[i] = (Boolean)this.ser.unmarshall(state, cc, jso.get(i));
                    ++i;
                }
                return arr;
            }
            Object[] arr = (Object[])Array.newInstance(clazz == Object.class ? Object.class : cc, jso.length());
            state.setSerialized(o, arr);
            while (i < jso.length()) {
                arr[i] = this.ser.unmarshall(state, cc, jso.get(i));
                ++i;
            }
            return arr;
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage() + " not found in json object", e);
        }
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        try {
            JSONArray arr = new JSONArray();
            if (o instanceof int[]) {
                int[] a = (int[])o;
                for (int i = 0; i < a.length; ++i) {
                    arr.put(a[i]);
                }
            } else if (o instanceof long[]) {
                long[] a = (long[])o;
                for (int i = 0; i < a.length; ++i) {
                    arr.put(a[i]);
                }
            } else if (o instanceof short[]) {
                short[] a = (short[])o;
                for (int i = 0; i < a.length; ++i) {
                    arr.put(a[i]);
                }
            } else if (o instanceof byte[]) {
                byte[] a = (byte[])o;
                for (int i = 0; i < a.length; ++i) {
                    arr.put(a[i]);
                }
            } else if (o instanceof float[]) {
                float[] a = (float[])o;
                for (int i = 0; i < a.length; ++i) {
                    arr.put(a[i]);
                }
            } else if (o instanceof double[]) {
                double[] a = (double[])o;
                for (int i = 0; i < a.length; ++i) {
                    arr.put(a[i]);
                }
            } else if (o instanceof char[]) {
                char[] a = (char[])o;
                for (int i = 0; i < a.length; ++i) {
                    arr.put(a[i]);
                }
            } else if (o instanceof boolean[]) {
                boolean[] a = (boolean[])o;
                for (int i = 0; i < a.length; ++i) {
                    arr.put(a[i]);
                }
            } else if (o instanceof Object[]) {
                Object[] a = (Object[])o;
                for (int i = 0; i < a.length; ++i) {
                    Object json = this.ser.marshall(state, o, a[i], new Integer(i));
                    if (JSONSerializer.CIRC_REF_OR_DUPLICATE == json) {
                        arr.put(JSONObject.NULL);
                        continue;
                    }
                    arr.put(json);
                }
            }
            return arr;
        }
        catch (JSONException e) {
            throw new MarshallException(e.getMessage() + " threw json exception", e);
        }
    }
}

