package it.unibo.tw.es1.servlets;

import it.unibo.tw.es1.beans.Libro;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class NuovoLibroServlet extends HttpServlet {
	
	private static final long serialVersionUID = 1L;
	
	
	
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		
		HttpSession session = req.getSession();
		
		Libro libro = (Libro)session.getAttribute("libro");
		if( libro != null){
			req.setAttribute("nuovoLibro", libro);
		}
		
		RequestDispatcher dispatcher = getServletContext().getRequestDispatcher("/nuovoLibro.jsp");
		dispatcher.forward(req, resp);
		
	}



	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		
		HttpSession session = req.getSession();
		
		String requestFromJsp = req.getParameter("req");
		if( requestFromJsp != null ){
			
			Libro libro = new Libro();
			libro.setAutore(req.getParameter("author"));
			libro.setTitolo(req.getParameter("title"));
			libro.setIsbn(req.getParameter("isbn"));
			
			if( requestFromJsp.equals("save") ){
				session.setAttribute("libro", libro);
				req.setAttribute("nuovoLibro", libro);
			}
			else if( requestFromJsp.equals("finalize") ){
				req.setAttribute("aggiungiLibro", libro);
				session.invalidate();
			}
		}
		else{
			Libro libro = (Libro)session.getAttribute("libro");
			req.setAttribute("nuovoLibro", libro);
		}
		
		RequestDispatcher dispatcher = getServletContext().getRequestDispatcher("/nuovoLibro.jsp");
		dispatcher.forward(req, resp);
		
	}
	
}
