<!-- pagina per la gestione di errori -->
<%@ page errorPage="../errors/failure.jsp"%>

<!-- accesso alla sessione -->
<%@ page session="true"%>

<!-- import di classi Java -->
<%@ page import="it.unibo.tw.es1.beans.Libro"%>
<%@ page import="it.unibo.tw.es1.beans.ElencoLibri"%>
<%@ page import="java.util.*"%>

<!-- metodi richiamati nel seguito -->
<%!
ElencoLibri cerca(ElencoLibri elenco, String autore) {
	ElencoLibri res = new ElencoLibri();	
	for ( Libro book : elenco.getElenco() ) {
		if ( book.getAutore().equals( autore ) ) {
			res.aggiungiLibro(book);
		}
	}
	return res;
}
%>

<!-- codice html restituito al client -->
<html>
	<head>
		<meta name="Author" content="cg">
		<title>Cerca Libri</title>
	</head>

	<body>
		<h3>Cerca Libri</h3>
		
		<jsp:useBean id="elencoLibri" class="it.unibo.tw.es1.beans.ElencoLibri" scope="application" />
		
		<!-- menu versione get a Servlet -->
		<a href="<%= request.getContextPath() %>/newBook">vai a nuovoLibro.jsp</a><br />
		
		<!-- menu versione post a Servlet -->
		<form name="nuovoLibroForm" action="newBook" method="post">
			<input type="submit" name="goto" value="vai a nuovoLibro.jsp"/><br />
		</form>	
		<br />
		
		<form>
			author: <input type="text" name="author"/><br />
			<input type="submit" name="req" value="cerca autore"/><br />
		</form>	
		<br />
		
		<form>
			<input type="submit" name="req" value="mostra tutti"/><br />
		</form>
		<br />
		<br />
		
		<% 
		Set<Libro> elencoLibriTrovati = null;
		if ( request.getParameter("req") != null ){
			if( request.getParameter("req").equals("cerca autore") ){
				String autore = request.getParameter("author");
				elencoLibriTrovati = cerca(elencoLibri, autore).getElenco();
			}
			else if( request.getParameter("req").equals("mostra tutti") ){
				elencoLibriTrovati = elencoLibri.getElenco();
			}
		}
		
		if( elencoLibriTrovati != null ){
		%>
			Numero libri trovati = <%= elencoLibriTrovati.size() %><br /><br />
		<%
			Iterator<Libro> itLibro = elencoLibriTrovati.iterator();
			while( itLibro.hasNext() ){
				Libro book = itLibro.next();
		%>
				Autore = <%= book.getAutore() %> <br />
				Titolo = <%= book.getTitolo() %> <br />
				ISBN   = <%= book.getIsbn() %> <br />
				<br />
		<%
			}
		}
		%>		

	</body>
</html>
