/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileSimple;
import org.hsqldb.rowio.RowInputBinary180;
import org.hsqldb.rowio.RowInputBinaryDecode;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary180;
import org.hsqldb.rowio.RowOutputBinaryEncode;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

public class DataFileCache {
    protected FileAccess fa;
    public static final int FLAG_ISSHADOWED = 1;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    public static final int FLAG_190 = 4;
    public static final int FLAG_HX = 5;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int LONG_EMPTY_INDEX_POS = 20;
    static final int FLAGS_POS = 28;
    static final int MIN_INITIAL_FREE_POS = 32;
    DataFileBlockManager freeBlocks;
    private static final int initIOBufferSize = 256;
    protected String dataFileName;
    protected String backupFileName;
    protected Database database;
    protected boolean fileModified;
    protected int cacheFileScale;
    protected boolean cacheReadonly;
    protected int cachedRowPadding = 8;
    protected int initialFreePos = 32;
    protected boolean hasRowInfo = false;
    protected int storeCount;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    boolean is180;
    protected RandomAccessInterface dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected int maxFreeBlocks;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public DataFileCache(Database database, String string) {
        this.initParams(database, string);
        this.cache = new Cache(this);
    }

    protected void initParams(Database database, String string) {
        this.dataFileName = string + ".data";
        this.backupFileName = string + ".backup";
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.cacheFileScale = database.logger.getCacheFileScale();
        this.cachedRowPadding = 8;
        if (this.cacheFileScale > 8) {
            this.cachedRowPadding = this.cacheFileScale;
        }
        if (this.initialFreePos < this.cacheFileScale) {
            this.initialFreePos = this.cacheFileScale;
        }
        this.cacheReadonly = database.logger.propFilesReadOnly;
        this.maxCacheRows = database.logger.propCacheMaxRows;
        this.maxCacheBytes = database.logger.propCacheMaxSize;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.cacheFileScale;
        this.maxFreeBlocks = database.logger.propMaxFreeBlocks;
        this.dataFile = null;
        this.shadowFile = null;
    }

    public void open(boolean bl) {
        this.fileFreePosition = 0L;
        this.database.logger.logInfoEvent("open start");
        try {
            boolean bl2 = this.database.logger.propNioDataFile;
            int n = this.database.logger.isStoredFileAccess() ? 3 : (this.database.isFilesInJar() ? 2 : (bl2 ? 1 : 0));
            if (bl || this.database.isFilesInJar()) {
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                this.dataFile.seek(28L);
                int n2 = this.dataFile.readInt();
                boolean bl3 = this.is180 = !BitMap.isSet(n2, 4);
                if (BitMap.isSet(n2, 5)) {
                    throw Error.error(453);
                }
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.initBuffers();
                return;
            }
            long l = 0L;
            boolean bl4 = this.fa.isStreamElement(this.dataFileName);
            if (bl4) {
                int n3 = this.database.logger.isStoredFileAccess() ? 3 : 0;
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n3);
                this.dataFile.seek(28L);
                int n4 = this.dataFile.readInt();
                boolean bl5 = BitMap.isSet(n4, 2);
                boolean bl6 = BitMap.isSet(n4, 1);
                this.is180 = !BitMap.isSet(n4, 4);
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.close();
                if (BitMap.isSet(n4, 5)) {
                    throw Error.error(453);
                }
                if (bl5) {
                    if (bl6) {
                        this.deleteBackup();
                    } else {
                        boolean bl7 = this.fa.isStreamElement(this.backupFileName);
                        if (!bl7) {
                            this.backupFile();
                        }
                    }
                    this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                } else {
                    boolean bl8 = bl6 ? this.restoreBackupIncremental() : this.restoreBackup();
                    if (!bl8 && this.fileFreePosition > (long)this.initialFreePos) {
                        throw Error.error(454);
                    }
                    this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                }
                this.dataFile.seek(4L);
                l = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                if (this.fileFreePosition <= (long)this.initialFreePos) {
                    this.initNewFile();
                }
                this.openShadowFile();
            } else {
                boolean bl9 = false;
                boolean bl10 = this.database.logger.propIncrementBackup;
                if (bl10) {
                    this.deleteBackup();
                } else {
                    bl9 = this.restoreBackup();
                }
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                if (!bl9) {
                    this.initNewFile();
                }
            }
            this.initBuffers();
            this.fileModified = false;
            this.freeBlocks = new DataFileBlockManager(this.maxFreeBlocks, this.cacheFileScale, l);
            this.database.logger.logInfoEvent("open end");
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("open failed", throwable);
            this.close(false);
            throw Error.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    void initNewFile() throws IOException {
        this.fileFreePosition = this.initialFreePos;
        this.dataFile.seek(12L);
        this.dataFile.writeLong(this.initialFreePos);
        int n = 0;
        if (this.database.logger.propIncrementBackup) {
            n = BitMap.set(n, 1);
        }
        n = BitMap.set(n, 2);
        n = BitMap.set(n, 4);
        this.dataFile.seek(28L);
        this.dataFile.writeInt(n);
        this.dataFile.synch();
        this.is180 = false;
    }

    void openShadowFile() {
        if (this.database.logger.propIncrementBackup && this.fileFreePosition != (long)this.initialFreePos) {
            this.shadowFile = new RAShadowFile(this.database, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIncrementBackup(boolean bl) {
        this.writeLock.lock();
        try {
            this.dataFile.seek(28L);
            int n = this.dataFile.readInt();
            n = bl ? BitMap.set(n, 1) : BitMap.unset(n, 1);
            this.dataFile.seek(28L);
            this.dataFile.writeInt(n);
            this.dataFile.synch();
            this.fileModified = true;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("backupFile failed", throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean restoreBackup() {
        this.deleteOrResetFreePos();
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            if (fileAccess.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fileAccess, 1);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 26, new Object[]{throwable.toString(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            if (this.fa.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.database, this.backupFileName, this.dataFileName);
                this.deleteBackup();
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw Error.error(452, iOException);
        }
    }

    public void close(boolean bl) {
        this.writeLock.lock();
        try {
            boolean bl2;
            if (this.dataFile == null) {
                return;
            }
            if (bl) {
                this.commitChanges();
            } else if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.dataFile.close();
            this.database.logger.logDetailEvent("dataFileCache file close");
            this.dataFile = null;
            if (!bl) {
                return;
            }
            boolean bl3 = bl2 = this.fileFreePosition == (long)this.initialFreePos;
            if (bl2) {
                this.deleteFile();
                this.deleteBackup();
            }
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("dataFileCache close failed", throwable);
            throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
            this.fileFreePosition = this.initialFreePos;
            if (this.freeBlocks != null) {
                this.freeBlocks.clear();
            }
            this.initBuffers();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustStoreCount(int n) {
        this.writeLock.lock();
        try {
            this.storeCount += n;
            if (this.storeCount == 0) {
                this.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void commitChanges() {
        this.writeLock.lock();
        try {
            if (this.cacheReadonly) {
                return;
            }
            this.database.logger.logInfoEvent("dataFileCache commit start");
            this.cache.saveAll();
            this.database.logger.logDetailEvent("dataFileCache save data");
            if (this.fileModified || this.freeBlocks.isModified()) {
                this.dataFile.seek(4L);
                this.dataFile.writeLong(this.freeBlocks.getLostBlocksSize());
                this.dataFile.seek(12L);
                this.dataFile.writeLong(this.fileFreePosition);
                this.dataFile.seek(28L);
                int n = this.dataFile.readInt();
                n = BitMap.set(n, 2);
                this.dataFile.seek(28L);
                this.dataFile.writeInt(n);
                this.database.logger.logDetailEvent("DataFileCache flags");
            }
            this.dataFile.synch();
            this.fileModified = false;
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("dataFileCache commit failed", throwable);
            throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null || this.rowOut.getOutputStream().getBuffer().length > 256) {
            this.rowOut = this.is180 ? new RowOutputBinary180(256, this.cachedRowPadding) : new RowOutputBinaryEncode(this.database.logger.getCrypto(), 256, this.cachedRowPadding);
        }
        if (this.rowIn == null || this.rowIn.getBuffer().length > 256) {
            this.rowIn = this.is180 ? new RowInputBinary180(new byte[256]) : new RowInputBinaryDecode(this.database.logger.getCrypto(), new byte[256]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileDefrag defrag() {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dataFileDefrag = new DataFileDefrag(this.database, this, this.dataFileName);
            dataFileDefrag.process();
            this.close(true);
            this.cache.clear();
            if (!this.database.logger.propIncrementBackup) {
                this.backupFile();
            }
            this.database.schemaManager.setTempIndexRoots(dataFileDefrag.getIndexRoots());
            this.database.logger.log.writeScript(false);
            this.database.getProperties().setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
            this.database.getProperties().setDBModified(2);
            this.database.logger.log.closeLog();
            this.database.logger.log.deleteLog();
            this.database.logger.log.renameNewScript();
            this.renameBackupFile();
            this.renameDataFile();
            this.database.getProperties().setDBModified(0);
            this.open(false);
            dataFileDefrag.updateTransactionRowIDs();
            this.database.schemaManager.setIndexRoots(dataFileDefrag.getIndexRoots());
            if (this.database.logger.log.dbLogWriter != null) {
                this.database.logger.log.openLog();
            }
            this.database.getProperties().setDBModified(1);
            DataFileDefrag dataFileDefrag2 = dataFileDefrag;
            return dataFileDefrag2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n, PersistentStore persistentStore) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = this.release(n);
            if (cachedObject != null) {
                int n2 = cachedObject.getStorageSize();
                this.freeBlocks.add(n, n2);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removePersistence(int n, PersistentStore persistentStore) {
    }

    int setFilePos(CachedObject cachedObject) {
        int n;
        int n2 = cachedObject.getStorageSize();
        int n3 = n = this.freeBlocks == null ? -1 : this.freeBlocks.get(n2);
        if (n == -1) {
            n = (int)(this.fileFreePosition / (long)this.cacheFileScale);
            long l = this.fileFreePosition + (long)n2;
            if (l > this.maxDataFileSize) {
                this.database.logger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
                throw Error.error(468);
            }
            boolean bl = this.dataFile.ensureLength(l);
            if (!bl) {
                this.database.logger.logSevereEvent("data file cannot be enlarged - disk spacee " + this.dataFileName, null);
                throw Error.error(468);
            }
            this.fileFreePosition = l;
        }
        cachedObject.setPos(n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            int n = this.setFilePos(cachedObject);
            this.cache.put(n, cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStorageSize(int n) {
        this.readLock.lock();
        try {
            CachedObject cachedObject = this.cache.get(n);
            if (cachedObject != null) {
                int n2 = cachedObject.getStorageSize();
                return n2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.readSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            int n = cachedObject.getPos();
            this.cache.replace(n, cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject cachedObject, PersistentStore persistentStore, boolean bl) {
        int n;
        this.readLock.lock();
        try {
            if (cachedObject.isInMemory()) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            n = cachedObject.getPos();
            if (n < 0) {
                CachedObject cachedObject3 = null;
                return cachedObject3;
            }
            cachedObject = this.cache.get(n);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject4 = cachedObject;
                return cachedObject4;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(n, persistentStore, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(int n, PersistentStore persistentStore, boolean bl) {
        if (n < 0) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject cachedObject = this.cache.get(n);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(n, persistentStore, bl);
    }

    private CachedObject getFromFile(int n, PersistentStore persistentStore, boolean bl) {
        CachedObject cachedObject = null;
        this.writeLock.lock();
        try {
            cachedObject = this.cache.get(n);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            for (int i = 0; i < 2; ++i) {
                RowInputInterface rowInputInterface;
                block14: {
                    try {
                        rowInputInterface = this.readObject(n);
                        if (rowInputInterface != null) break block14;
                        CachedObject cachedObject3 = null;
                        return cachedObject3;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.cache.forceCleanUp();
                        System.gc();
                        if (i <= 0) continue;
                        throw outOfMemoryError;
                    }
                }
                cachedObject = persistentStore.get(rowInputInterface);
                break;
            }
            n = cachedObject.getPos();
            this.cache.put(n, cachedObject);
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            persistentStore.set(cachedObject);
            CachedObject cachedObject4 = cachedObject;
            return cachedObject4;
        }
        catch (HsqlException hsqlException) {
            this.database.logger.logSevereEvent(this.dataFileName + " getFromFile " + n, hsqlException);
            throw hsqlException;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInputInterface getRaw(int n) {
        this.writeLock.lock();
        try {
            RowInputInterface rowInputInterface = this.readObject(n);
            return rowInputInterface;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected int readSize(int n) {
        this.writeLock.lock();
        try {
            this.dataFile.seek((long)n * (long)this.cacheFileScale);
            int n2 = this.dataFile.readInt();
            return n2;
        }
        catch (IOException iOException) {
            throw Error.error(466, iOException);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected RowInputInterface readObject(int n) {
        try {
            this.dataFile.seek((long)n * (long)this.cacheFileScale);
            int n2 = this.dataFile.readInt();
            this.rowIn.resetRow(n, n2);
            this.dataFile.read(this.rowIn.getBuffer(), 4, n2 - 4);
            return this.rowIn;
        }
        catch (IOException iOException) {
            throw Error.error(466, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject release(int n) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = this.cache.release(n);
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRows(CachedObject[] cachedObjectArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        try {
            this.copyShadow(cachedObjectArray, n, n2);
            this.setFileModified();
            for (int i = n; i < n + n2; ++i) {
                CachedObject cachedObject = cachedObjectArray[i];
                this.saveRowNoLock(cachedObject);
                cachedObjectArray[i] = null;
            }
        }
        catch (HsqlException hsqlException) {
            this.database.logger.logSevereEvent("saveRows failed", hsqlException);
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("saveRows failed", throwable);
            throw Error.error(466, throwable);
        }
        finally {
            this.initBuffers();
        }
    }

    public void saveRow(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.copyShadow(cachedObject);
            this.setFileModified();
            this.saveRowNoLock(cachedObject);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("saveRow failed", throwable);
            throw Error.error(466, throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRowNoLock(CachedObject cachedObject) {
        try {
            this.rowOut.reset();
            cachedObject.write(this.rowOut);
            this.dataFile.seek((long)cachedObject.getPos() * (long)this.cacheFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (IOException iOException) {
            throw Error.error(466, iOException);
        }
    }

    protected void copyShadow(CachedObject[] cachedObjectArray, int n, int n2) throws IOException {
        if (this.shadowFile != null) {
            for (int i = n; i < n + n2; ++i) {
                CachedObject cachedObject = cachedObjectArray[i];
                long l = (long)cachedObject.getPos() * (long)this.cacheFileScale;
                this.shadowFile.copy(l, cachedObject.getStorageSize());
            }
            this.shadowFile.synch();
        }
    }

    protected void copyShadow(CachedObject cachedObject) throws IOException {
        if (this.shadowFile != null) {
            long l = (long)cachedObject.getPos() * (long)this.cacheFileScale;
            this.shadowFile.copy(l, cachedObject.getStorageSize());
            this.shadowFile.synch();
        }
    }

    void backupFile() {
        this.writeLock.lock();
        try {
            if (this.database.logger.propIncrementBackup) {
                if (this.fa.isStreamElement(this.backupFileName)) {
                    this.deleteBackup();
                }
                return;
            }
            if (this.fa.isStreamElement(this.dataFileName)) {
                FileArchiver.archive(this.dataFileName, this.backupFileName + ".new", this.database.logger.getFileAccess(), 1);
            }
        }
        catch (IOException iOException) {
            this.database.logger.logSevereEvent("backupFile failed", iOException);
            throw Error.error(466, iOException);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameBackupFile() {
        this.writeLock.lock();
        try {
            if (this.database.logger.propIncrementBackup) {
                this.deleteBackup();
                return;
            }
            if (this.fa.isStreamElement(this.backupFileName + ".new")) {
                this.deleteBackup();
                this.fa.renameElement(this.backupFileName + ".new", this.backupFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameDataFile() {
        this.writeLock.lock();
        try {
            if (this.fa.isStreamElement(this.dataFileName + ".new")) {
                this.deleteFile();
                this.fa.renameElement(this.dataFileName + ".new", this.dataFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFile() {
        this.writeLock.lock();
        try {
            this.fa.removeElement(this.dataFileName);
            if (this.database.logger.isStoredFileAccess()) {
                return;
            }
            if (this.fa.isStreamElement(this.dataFileName)) {
                this.database.logger.log.deleteOldDataFiles();
                this.fa.removeElement(this.dataFileName);
                if (this.fa.isStreamElement(this.dataFileName)) {
                    String string = this.newDiscardFileName();
                    this.fa.renameElement(this.dataFileName, string);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    String newDiscardFileName() {
        String string = StringUtil.toPaddedString(Integer.toHexString((int)System.currentTimeMillis()), 8, '0', true);
        String string2 = this.dataFileName + "." + string + ".old";
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteBackup() {
        this.writeLock.lock();
        try {
            if (this.fa.isStreamElement(this.backupFileName)) {
                this.fa.removeElement(this.backupFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteOrResetFreePos() {
        this.deleteFile();
        if (this.database.logger.isStoredFileAccess()) {
            return;
        }
        if (!this.database.logger.getFileAccess().isStreamElement(this.dataFileName)) {
            return;
        }
        try {
            this.dataFile = new ScaledRAFileSimple(this.dataFileName, "rws");
            this.initNewFile();
        }
        catch (IOException iOException) {
            this.database.logger.logSevereEvent("deleteOrResetFreePos failed", iOException);
        }
        finally {
            if (this.dataFile != null) {
                try {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                catch (IOException iOException) {
                    this.database.logger.logWarningEvent("error closing RA file", iOException);
                }
            }
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public int getFreeBlockCount() {
        return this.freeBlocks == null ? 0 : this.freeBlocks.size();
    }

    public int getTotalFreeBlockSize() {
        return 0;
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public int getAccessCount() {
        return this.cache.incrementAccessCount();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFileModified() {
        this.writeLock.lock();
        try {
            if (!this.fileModified) {
                long l = this.cache.saveAllTimer.elapsedTime();
                this.cache.saveAllTimer.start();
                this.dataFile.seek(28L);
                int n = this.dataFile.readInt();
                n = BitMap.unset(n, 2);
                this.dataFile.seek(28L);
                this.dataFile.writeInt(n);
                this.dataFile.synch();
                this.cache.saveAllTimer.stop();
                this.database.logger.logDetailEvent("flags set " + this.cache.saveAllTimer.elapsedTime());
                this.fileModified = true;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getFlags() {
        try {
            this.dataFile.seek(28L);
            int n = this.dataFile.readInt();
            return n;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }
}

