package hibernate;

import java.io.*;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Restrictions;

public class OspedaliTest {
	
		public static void main(String[] argv)
		{
			 
			Session session = new Configuration().configure().buildSessionFactory().openSession();
			Transaction tx = null;
			
			 try {		  
				  tx = session.beginTransaction();
				  
				  
				  
				  TipoAccertamento ta = new TipoAccertamento();
				  ta.setCodiceTipoAcc(1);
				  ta.setTipoAccId(1);
				  ta.setDescrizione("analisi di laboratorio");
				  Set<Accertamento> a = new HashSet<Accertamento>()	;	
				  
				  session.persist(ta);
				  
				  Accertamento accertamento = new Accertamento();
				  accertamento.setAccId(1);
				  accertamento.setCodiceAcc(1);
				  accertamento.setDescrizione("monocromo ed alcolemia");
				  accertamento.setNome("prelievo di sangue");
				  accertamento.setTipoAccertamento(ta);
				  
				  session.persist(accertamento);
				  
				  accertamento = new Accertamento();
				  accertamento.setAccId(2);
				  accertamento.setCodiceAcc(2);
				  accertamento.setDescrizione("canabinoidi, oppiacei, sintetici");
				  accertamento.setNome("analisi delle urine");
				  accertamento.setTipoAccertamento(ta);  
				 
			
				  ta.setAccertamenti(a);
				  
				 
				  
				  session.persist(accertamento);
				  
				  Set<Ospedale> ospedali = new HashSet<Ospedale>();
				  Set<TipoAccertamento> tipiAccertamento = new HashSet<TipoAccertamento>();
				  
				  Ospedale o = new Ospedale();
				  o.setOspId(1);
				  o.setCodice(1);
				  o.setCitta("Bologna");
				  o.setNome("S.Orsola");
				  o.setIndirizzo("Via Massarenti");
				  o.setTipiAccertamento(tipiAccertamento);
				  
				  session.persist(o);
				  
				  
				  ospedali.add(o);
				  
				  o = new Ospedale();
				  o.setOspId(2);
				  o.setCodice(2);
				  o.setCitta("Bologna");
				  o.setNome("Maggiore");
				  o.setIndirizzo("Via Saffi");
				  o.setTipiAccertamento(tipiAccertamento);
				  session.persist(o);
				  
				  ospedali.add(o);
				  
				  o = new Ospedale();
				  o.setOspId(3);
				  o.setCodice(3);
				  o.setCitta("Fermo");
				  o.setNome("Murri");
				  o.setIndirizzo("Murri");
				  o.setTipiAccertamento(tipiAccertamento);
				  session.persist(o);
				  
				  
				  ospedali.add(o);
				  ta.setOspedali(ospedali);
				  session.saveOrUpdate(ta);
				  
				  tx.commit();
				  
				  Query firstQuery = session.createQuery("from "+Ospedale.class.getSimpleName()+" where citta = ? and nome = ?");
				  firstQuery.setString(0, "Bologna");
				  firstQuery.setString(1, "S.Orsola");
				  List<Ospedale> ospedaliRes = firstQuery.list();
				  String firstQueryResult ="";
				  String secondQueryResult ="";
				  for(Ospedale os : ospedaliRes)
				  {
					  Set<TipoAccertamento> tipiAcc = os.getTipiAccertamento();
					  for(TipoAccertamento tipo : tipiAcc)
					  {
						  if(tipo.getDescrizione().compareTo("analisi di laboratorio")==0)
						  {
							  Set<Accertamento> accertamenti = tipo.getAccertamenti();
							  for(Accertamento acc :accertamenti)
							  {
								  firstQueryResult=firstQueryResult+acc.getNome()+"\n";
							  }
						  }
					  }
				  }
				  
				  Query secondQuery = session.createQuery("from "+Ospedale.class.getSimpleName());
				  ospedaliRes= secondQuery.list();
				  for(Ospedale os : ospedaliRes)
				  {
					  secondQueryResult = secondQueryResult+os.getNome()+ " " + os.getIndirizzo() +" "+os.getCitta()+"\n Numero Accertamenti erogabili: ";
					  Set<TipoAccertamento> tipiAcc = os.getTipiAccertamento();
					  int numAccCounter=0;
					  for(TipoAccertamento tipo : tipiAcc)
					  {
						  numAccCounter += tipo.getAccertamenti().size();
					  }
					  secondQueryResult=secondQueryResult+numAccCounter +"\n";
				  }
				 
				  	PrintWriter pw = new  PrintWriter(new FileWriter("Ospedali.txt"));
				  	pw.println(firstQueryResult);
				  	pw.append(secondQueryResult);
				  	pw.close();
			 }
			 catch (Exception e1) {
			      if (tx != null){
			    	  try{
			    		  tx.rollback();
			    	  }
			    	  catch(Exception e2){
			    		  e2.printStackTrace();
			    	  }
			      }
			      e1.printStackTrace();
			  }
			  finally {
				  session.close();
			  }
		}

}
